/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __AudioMixer_h__
#define __AudioMixer_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif

#include <flTypes/flUIDs.h>
#include <flTypes/IAudioMixer.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CAudioInputPin;
class flAudioBuffer;
//------------------------------------------------------------------------------
class CAudioMixer :
			public CTransInPlaceFilter,
			public CPersistStream, 
			public IAudioMixer,
			public ISpecifyPropertyPages
{
	friend class CAudioInputPin;

public:
	static CUnknown * WINAPI	CreateInstance(LPUNKNOWN punk, HRESULT *phr);

private:
	CAudioMixer(TCHAR *tszName, LPUNKNOWN punk, HRESULT *phr);
	virtual ~CAudioMixer();

public:
	DECLARE_IUNKNOWN;

public:
	STDMETHODIMP		NonDelegatingQueryInterface(REFIID riid, void ** ppv);

	// CTransInPlaceFilter Overrides
	virtual int			GetPinCount();
	virtual CBasePin*	GetPin( int n );
	STDMETHODIMP		FindPin(LPCWSTR Id, IPin **ppPin);

	STDMETHODIMP		Stop();
	STDMETHODIMP		Run(REFERENCE_TIME tStart);

	HRESULT				CheckInputType(const CMediaType* mtIn);

	// IPersistStream
    STDMETHODIMP		GetClassID(CLSID *pClsid);
	HRESULT				WriteToStream(IStream *pStream);
    HRESULT				ReadFromStream(IStream *pStream);
	DWORD				GetSoftwareVersion(void);
	int					SizeMax();

	// IAudioMixer
	STDMETHODIMP		get_BufferSize(flUInt *size);
	STDMETHODIMP		put_BufferSize(flUInt size);
	STDMETHODIMP		is_Mixing(flBool *flag);

	// ISpecifyPropertyPages
	STDMETHODIMP		GetPages(CAUUID *pPages);

private:
	// CTransformInPlaceFilter Overrides
	HRESULT				Transform(IMediaSample *pSample);

private:
	HRESULT				ReceiveAudio(IMediaSample *pSource, CAudioInputPin *ppin);
	HRESULT				CheckAudioInputType(const CMediaType* mtIn);

protected:
    CCritSec			_filterLock;

	flBool				_runFlag;
	flULong				_mixingTime;
	flULong				_sampleTime;

	CAudioInputPin*		_audioInputPin;
	
	flAudioBuffer*		_audioBuffer;

	flUInt				_bufferSize;
	flByte*				_buffer;
};
//------------------------------------------------------------------------------
#endif //__AudioMixer_h__
