/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include <flAudioMixer/flAudioBuffer.h>
#ifdef _DEBUG
#include <flBase/flNotify.h>
#endif
//------------------------------------------------------------------------------
flAudioBuffer::flAudioBuffer()
{
	_bufferSize		= 0;
	_buffer			= NULL;

	_setIndex		= 0;
	_getIndex		= 0;
}
//------------------------------------------------------------------------------
flAudioBuffer::~flAudioBuffer()
{
	delete _buffer;
}
//------------------------------------------------------------------------------
void
flAudioBuffer::setBufferSize(flUInt size)
{
	if (_bufferSize == size)
		return ;

	flByte* newBuffer = new flByte[size];
	memset(newBuffer, 0, size);
	if (_bufferSize != 0)
		memcpy(newBuffer, _buffer, (size < _bufferSize ? size : _bufferSize));

	_bufferSize = size;
	delete _buffer;
	_buffer = newBuffer;
}
//------------------------------------------------------------------------------
flUInt
flAudioBuffer::getBufferSize() const
{
	return _bufferSize;
}
//------------------------------------------------------------------------------
flBool
flAudioBuffer::setData(const flByte* data, flUInt size, flBool overwriteOn)
{
	if (_bufferSize == 0 || _bufferSize < size)
		return false;

	if (!overwriteOn && _getIndex + _bufferSize < _setIndex + size)
		return false;

	flUInt index = (_setIndex % _bufferSize);
	if (index + size < _bufferSize)
	{
		memcpy(_buffer + index, data, size);
	}
	else
	{
		flUInt partSize = _bufferSize - index;

		memcpy(_buffer + index, data, partSize);
		memcpy(_buffer, data + partSize, size - partSize);
	}

	_setIndex += size;

#ifdef _DEBUG
//	flNotify::post(flNotify::L_INFO, "Set Data Index[%d] Size[%d]", _setIndex, size);
#endif

	return true;
}
//------------------------------------------------------------------------------
flBool
flAudioBuffer::getData(flByte* data, flUInt size)
{
	if (_bufferSize == 0 || _bufferSize < size)
		return false;

	if (_bufferSize < _setIndex - _getIndex)
		_getIndex = _setIndex - _bufferSize;

	if (_setIndex < _getIndex + size)
		return false;

	flUInt index = (_getIndex % _bufferSize);
	if (index + size < _bufferSize)
	{
		memcpy(data, _buffer + index, size);
	}
	else
	{
		flUInt partSize = _bufferSize - index;

		memcpy(data, _buffer + index, partSize);
		memcpy(data + partSize, _buffer, size - partSize);
	}

	_getIndex += size;

#ifdef _DEBUG
//	flNotify::post(flNotify::L_INFO, " Get Data Index[%d] Size[%d]", _getIndex, size);
#endif

	return true;
}
//------------------------------------------------------------------------------
void
flAudioBuffer::clear()
{
	_setIndex = 0;
	_getIndex = 0;

	if (_bufferSize == 0)
		return ;

	memset(_buffer, 0, _bufferSize);
}
//------------------------------------------------------------------------------
