/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#define WIN32_LEAN_AND_MEAN
#include <streams.h>
#include <flAudioMixer/AudioMixer.h>
#include <flAudioMixer/flAudioInputPin.h>
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
CAudioInputPin::CAudioInputPin(TCHAR *pObjectName,
						CAudioMixer *pAudioMixer, HRESULT * phr, LPCWSTR pName) :
CBaseInputPin(pObjectName, pAudioMixer, &pAudioMixer->m_csFilter, phr, pName)
{
	DbgLog((LOG_TRACE,2,TEXT("CAudioInputPin::CAudioInputPin")));
	_audioMixer  = pAudioMixer;
}
//------------------------------------------------------------------------------
CAudioInputPin::~CAudioInputPin()
{
}
//------------------------------------------------------------------------------
HRESULT
CAudioInputPin::CheckMediaType(const CMediaType* pmt)
{
	return _audioMixer->CheckAudioInputType(pmt);
}
//------------------------------------------------------------------------------
// IMemInputPin
HRESULT
CAudioInputPin::Receive(IMediaSample * pSample)
{
	HRESULT hr;
	ASSERT(pSample);

	hr = CBaseInputPin::Receive(pSample);
	if (S_OK == hr)
		hr = _audioMixer->ReceiveAudio(pSample, this);

	return hr;
}
//------------------------------------------------------------------------------
STDMETHODIMP
CAudioInputPin::BeginFlush(void)
{
	CAutoLock lock(&_audioMixer->m_csFilter);
	HRESULT hr = CBaseInputPin::BeginFlush();
	if (FAILED(hr))
		return hr;

	return S_OK;
}
//------------------------------------------------------------------------------
STDMETHODIMP
CAudioInputPin::EndFlush(void)
{
	CAutoLock lock(&_audioMixer->m_csFilter);
	return CBaseInputPin::EndFlush();
}
//------------------------------------------------------------------------------
STDMETHODIMP
CAudioInputPin::EndOfStream(void)
{
	CAutoLock lock(&_audioMixer->m_csReceive);
	HRESULT hr = CheckStreaming();
	return hr;
}
//------------------------------------------------------------------------------
STDMETHODIMP
CAudioInputPin::NewSegment(REFERENCE_TIME tStart, REFERENCE_TIME tStop, double dRate)
{
	return CBasePin::NewSegment(tStart, tStop, dRate);
}
//------------------------------------------------------------------------------
HRESULT
CAudioInputPin::CheckStreaming()
{
	ASSERT(IsConnected());

	if(m_bFlushing)
		return S_FALSE;

	if(IsStopped())
		return VFW_E_WRONG_STATE;

	if(m_bRunTimeError)
		return VFW_E_RUNTIME_ERROR;

	return S_OK;
}
//------------------------------------------------------------------------------
CMediaType&
CAudioInputPin::CurrentMediaType()
{
	return m_mt;
}
//------------------------------------------------------------------------------
