/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flAudioInputPin_h__
#define __flAudioInputPin_h__
//------------------------------------------------------------------------------
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CAudioMixer;
//------------------------------------------------------------------------------
class CAudioInputPin : public CBaseInputPin
{
public:
	CAudioInputPin(TCHAR *pObjectName,
						CAudioMixer *pAudioMixer,
						HRESULT * phr,
						LPCWSTR pName);

	~CAudioInputPin();

public:
	HRESULT			CheckMediaType(const CMediaType* mtIn);

	// IMemInputPin
	STDMETHODIMP	Receive(IMediaSample * pSample);
	STDMETHODIMP	BeginFlush(void);
	STDMETHODIMP	EndFlush(void);
	STDMETHODIMP	EndOfStream(void);

	STDMETHODIMP	NewSegment(REFERENCE_TIME tStart, REFERENCE_TIME tStop, double dRate);

	virtual HRESULT	CheckStreaming();

public:
	CMediaType&		CurrentMediaType();

protected:
	CAudioMixer*	_audioMixer;
};
//------------------------------------------------------------------------------
#endif // __flAudioInputPin_h__
