/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef	__flArray_h__
#define	__flArray_h__
//------------------------------------------------------------------------------
#include <flBase/flFuncs.h>
//------------------------------------------------------------------------------
template<class T,
		 class LF=flLessFunc<T>,
		 class GF=flGreaterFunc<T>,
		 class CPF=flCopyFunc<T>,
		 class CMF=flCompFunc<T> >
class flArray
{
public:
	static const flUInt	DEFAULT_GROWSIZE = 16;
	typedef flInt		(*SortFunc)(const T*, const T*);

	flArray();
	flArray(const flArray& array);
	~flArray();

public:
	void			copy(const flArray& array);
	flBool			equal(const flArray& array) const;

	void			clear();
	void			fit();

	void			setBufferSize(flUInt size);
	flUInt			getBufferSize() const;

	void			setGrowSize(flUInt size);
	flUInt			getGrowSize() const;

	void			setSize(flUInt size);
	flUInt			getSize() const;

	void			set(flUInt index, const T& value);
	T&				get(flUInt index);
	const T&		get(flUInt index) const;
	const T*		getPointer() const;

	void			add(const T& value);
	void			add(const T* vlaues, flUInt numValues);
	void			insert(flUInt index, const T& value);
	flBool			find(const T& value) const;
	flBool			find(const T& value, flUInt& index) const;
	void			remove(const T& value);
	void			removeIndex(flUInt index);
	void			removeAll(const T& value);
	void			replace(const T& oldValue, const T& newValue);

	void			sortLess();
	void			sortGreater();
	void			sort(SortFunc sortFunc);

public:
	flBool			operator ==(const flArray& array) const;
	flBool			operator !=(const flArray& array) const;

	flArray&		operator =(const flArray& array);

	T&				operator [](flUInt i);
	const T&		operator [](flUInt i) const;
	
private:
	static flInt	lessFunc(const T* value1, const T* value2);
	static flInt	greaterFunc(const T* value1, const T* value2);

private:
	T*				_values;
	flUInt			_bufferSize;
	flUInt			_size;
	flUInt			_growSize;
};
//------------------------------------------------------------------------------
#include <flBase/flArray.inl>
//------------------------------------------------------------------------------
typedef flArray<flBool>			flBoolArray;
typedef flArray<flChar>			flCharArray;
typedef flArray<flByte>			flByteArray;
typedef flArray<flShort>		flShortArray;
typedef flArray<flUShort>		flUShortArray;
typedef flArray<flLong>			flLongArray;
typedef flArray<flULong>		flULongArray;
typedef flArray<flInt>			flIntArray;
typedef flArray<flUInt>			flUIntArray;
typedef flArray<flInt32>		flInt32Array;
typedef flArray<flUInt32>		flUInt32Array;
typedef flArray<flInt64>		flInt64Array;
typedef flArray<flUInt64>		flUInt64Array;
typedef flArray<flFloat>		flFloatArray;
typedef flArray<flDouble>		flDoubleArray;
//------------------------------------------------------------------------------
#endif	// !__flArray_h__
