/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef	__flArray_inl__
#define	__flArray_inl__
//------------------------------------------------------------------------------
#include <flBase/flQuickSort.h>
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
flArray<T, LF, GF, CPF, CMF>::flArray() :
_values(NULL),
_bufferSize(0),
_size(0),
_growSize(DEFAULT_GROWSIZE)
{
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
flArray<T, LF, GF, CPF, CMF>::flArray(const flArray& array) :
_values(NULL),
_bufferSize(0),
_size(0),
_growSize(DEFAULT_GROWSIZE)
{
	setBufferSize(array._bufferSize);
	_size		= array._size;
	_growSize	= array._growSize;

	if (_size)
	{
		CPF copyFunc;
		copyFunc(_values, array._values, array._size);
	}
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
flArray<T, LF, GF, CPF, CMF>::~flArray()
{
	delete [] _values;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flArray<T, LF, GF, CPF, CMF>::copy(const flArray& array)
{
	if (this == &array)
		return;

	clear();

	setBufferSize(array._bufferSize);
	_size		= array._size;
	_growSize	= array._growSize;

	if (_size)
	{
		CPF copyFunc;
		copyFunc(_values, array._values, array._size);
	}
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
flBool
flArray<T, LF, GF, CPF, CMF>::equal(const flArray& array) const
{
	if (this == &array)
		return true;
	if (_size != array._size)
		return false;
	if (_size == 0)
		return false;

	CMF compFunc;
	return compFunc(_values, array._values, _size);
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flArray<T, LF, GF, CPF, CMF>::clear()
{
	delete [] _values;
	_values		= NULL;
	_size		= 0;
	_bufferSize	= 0;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flArray<T, LF, GF, CPF, CMF>::fit()
{
	if (_bufferSize > _size)
		setBufferSize(_size);
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flArray<T, LF, GF, CPF, CMF>::setBufferSize(flUInt size)
{
	if (_bufferSize == size)
		return;

	if (size == 0)
	{
		clear();
		return;
	}

	T* p = new T[size];

	if (_values)
	{
		flUInt num = (_size < size) ? _size : size;
		if (num)
		{
			CPF copyFunc;
			copyFunc(p, _values, num);
		}
		delete [] _values;
	}

	_values = p;
	if (_size > size)
		_size = size;
	_bufferSize = size;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
inline flUInt
flArray<T, LF, GF, CPF, CMF>::getBufferSize() const
{
	return _bufferSize;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
inline void
flArray<T, LF, GF, CPF, CMF>::setGrowSize(flUInt size)
{
	_growSize = (size > 0) ? size : DEFAULT_GROWSIZE;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
inline flUInt
flArray<T, LF, GF, CPF, CMF>::getGrowSize() const
{
	return _growSize;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flArray<T, LF, GF, CPF, CMF>::setSize(flUInt size)
{
	while (_bufferSize <= size)
		setBufferSize(_bufferSize + _growSize);
	_size = size;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
inline flUInt
flArray<T, LF, GF, CPF, CMF>::getSize() const
{
	return _size;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flArray<T, LF, GF, CPF, CMF>::set(flUInt index, const T& value)
{
	assert(index < _size);
	_values[index] = value;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
inline T&
flArray<T, LF, GF, CPF, CMF>::get(flUInt index)
{
	assert(index < _size);
	return _values[index];
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
inline const T&
flArray<T, LF, GF, CPF, CMF>::get(flUInt index) const
{
	assert(index < _size);
	return _values[index];
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
inline const T*
flArray<T, LF, GF, CPF, CMF>::getPointer() const
{
	return _values;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flArray<T, LF, GF, CPF, CMF>::add(const T& value)
{
	if (_size == _bufferSize)
		setBufferSize(_bufferSize + _growSize);
	_values[_size++] = value;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flArray<T, LF, GF, CPF, CMF>::add(const T* values, flUInt numValues)
{
	while (_size + numValues >= _bufferSize)
		setBufferSize(_bufferSize + _growSize);

	CPF copyFunc;
	copyFunc(&_values[_size], values, numValues);
	_size += numValues;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flArray<T, LF, GF, CPF, CMF>::insert(flUInt index, const T& value)
{
	assert(_size != 0 && index < _size);

	T* oldValues = _values;

	if (_size == _bufferSize)
		_bufferSize += _growSize;
	_values = new T[_bufferSize];

	CPF copyFunc;
	if (index)
		copyFunc(_values, oldValues, index);
	_values[index] = value;
	copyFunc(&_values[index+1], &oldValues[index], _size-index);

	delete [] oldValues;

	++_size;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
flBool
flArray<T, LF, GF, CPF, CMF>::find(const T& value) const
{
	for (flUInt i = 0; i < _size; ++i)
	{
		if (_values[i] == value)
			return true;
	}
	return false;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
flBool
flArray<T, LF, GF, CPF, CMF>::find(const T& value, flUInt& index) const
{
	for (flUInt i = 0; i < _size; ++i)
	{
		if (_values[i] == value)
		{
			index = i;
			return true;
		}
	}
	return false;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flArray<T, LF, GF, CPF, CMF>::remove(const T& value)
{
	flUInt index;
	if (!find(value, index))
		return;

	removeIndex(index);
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flArray<T, LF, GF, CPF, CMF>::removeIndex(flUInt index)
{
	assert(index < _size);

	if (index == _size-1)
	{
		--_size;
		return;
	}

	T* oldValues = _values;
	_values = new T[_bufferSize];

	CPF copyFunc;
	if (index)
		copyFunc(_values, oldValues, index);
	copyFunc(&_values[index], &oldValues[index+1], _size-index-1);

	delete [] oldValues;

	--_size;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flArray<T, LF, GF, CPF, CMF>::removeAll(const T& value)
{
	for (flUInt i = 0; i < _size; ++i)
	{
		if (_values[i] == value)
		{
			removeIndex(i);
			--i;
		}
	}
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flArray<T, LF, GF, CPF, CMF>::replace(const T& oldValue, const T& newValue)
{
	for (flUInt i = 0; i < _size; ++i)
	{
		if (_values[i] == oldValue)
			_values[i] = newValue;
	}
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flArray<T, LF, GF, CPF, CMF>::sortLess()
{
	if (_size > 1)
	{
		flQuickSort::sort((void*)_values, _size,
			sizeof(T), (flQuickSort::SortFunc)lessFunc);
	}
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flArray<T, LF, GF, CPF, CMF>::sortGreater()
{
	if (_size > 1)
	{
		flQuickSort::sort((void*)_values, _size,
			sizeof(T), (flQuickSort::SortFunc)greaterFunc);
	}
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flArray<T, LF, GF, CPF, CMF>::sort(SortFunc sortFunc)
{
	if (_size > 1)
	{
		flQuickSort::sort((void*)_values, _size,
			sizeof(T), (flQuickSort::SortFunc)sortFunc);
	}
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
inline flBool
flArray<T, LF, GF, CPF, CMF>::operator ==(const flArray& array) const
{
	return equal(array);
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
inline flBool
flArray<T, LF, GF, CPF, CMF>::operator !=(const flArray& array) const
{
	return !equal(array);
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
inline flArray<T, LF, GF, CPF, CMF>&
flArray<T, LF, GF, CPF, CMF>::operator =(const flArray& array)
{
	copy(array);
	return *this;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
inline T&
flArray<T, LF, GF, CPF, CMF>::operator [](flUInt i)
{
	return _values[i];
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
inline const T&
flArray<T, LF, GF, CPF, CMF>::operator [](flUInt i) const
{
	return _values[i];
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
inline flInt
flArray<T, LF, GF, CPF, CMF>::lessFunc(const T* value1, const T* value2)
{
	LF lessFunc;
	return lessFunc(value1, value2);
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
inline flInt
flArray<T, LF, GF, CPF, CMF>::greaterFunc(const T* value1, const T* value2)
{
	GF greaterFunc;
	return greaterFunc(value1, value2);
}
//------------------------------------------------------------------------------
#endif	// !__flArray_inl__
