/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef	__flBase_h__
#define	__flBase_h__
//------------------------------------------------------------------------------
#pragma warning(disable: 4251)
#pragma warning(disable: 4311)
#pragma warning(disable: 4312)
//------------------------------------------------------------------------------
#include <windows.h>
#include <cstdio>
#include <typeinfo>
#include <cassert>
//------------------------------------------------------------------------------
typedef bool					flBool;
typedef char					flChar;
typedef unsigned char			flByte;
typedef short					flShort;
typedef unsigned short			flUShort;
typedef long					flLong;
typedef unsigned long			flULong;
typedef int						flInt;
typedef unsigned int			flUInt;
#ifdef _WIN32
typedef __int32					flInt32;
typedef unsigned __int32		flUInt32;
typedef __int64					flInt64;
typedef unsigned __int64		flUInt64;
#else
typedef long					flInt32;
typedef unsigned long			flUInt32;
typedef long long				flInt64;
typedef unsigned long long		flUInt64;
#endif
typedef float					flFloat;
typedef double					flDouble;
#ifdef __BORLANDC__
typedef const std::type_info&	flClassType;
#else
typedef const type_info&		flClassType;
#endif
//------------------------------------------------------------------------------
template<class T> inline const T flMax(const T& x, const T& y)
{ return x > y ? x : y; }
//------------------------------------------------------------------------------
template<class T> inline const T flMin(const T& x, const T& y)
{ return x < y ? x : y; }
//------------------------------------------------------------------------------
template<class T> inline void flSwap(T& x, T& y)
{ T t; t = x; x = y; y = t; }
//------------------------------------------------------------------------------
#endif	// !__flBase_h__
