/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "Stdafx.h"
#include <flBase/flByteStream.h>
#include <assert.h>
//------------------------------------------------------------------------------
// flOutputByteStream
#define DEF_GROWSIZE	1024
//------------------------------------------------------------------------------
flOutputByteStream::flOutputByteStream()
{
	_growSize = DEF_GROWSIZE;

	_size = 0;
	_buffer = NULL;
	_bufferSize = 0;
}
//------------------------------------------------------------------------------
flOutputByteStream::~flOutputByteStream()
{
	delete _buffer;
}
//------------------------------------------------------------------------------
void
flOutputByteStream::reset()
{
	_size = 0;
}
//------------------------------------------------------------------------------
void flOutputByteStream::get(const flChar*& data, flUInt& size)
{
	data = _buffer;
	size = _size;
}
//------------------------------------------------------------------------------
void
flOutputByteStream::setGrowSize(flUInt size)
{
	_growSize = size;
}
//------------------------------------------------------------------------------
flUInt
flOutputByteStream::getGrowSize() const
{
	return _growSize;
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeBool(flBool data)
{
	_write(&data, sizeof(flBool));
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeChar(flChar data)
{
	_write(&data, sizeof(flChar));
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeByte(flByte data)
{
	_write(&data, sizeof(flByte));
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeShort(flShort data)
{
	_write(&data, sizeof(flShort));
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeUShort(flUShort data)
{
	_write(&data, sizeof(flUShort));
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeInt(flInt data)
{
	_write(&data, sizeof(flInt));
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeUInt(flUInt data)
{
	_write(&data, sizeof(flUInt));
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeLong(flLong data)
{
	_write(&data, sizeof(flLong));
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeULong(flULong data)
{
	_write(&data, sizeof(flULong));
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeFloat(flFloat data)
{
	_write(&data, sizeof(flFloat));
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeDouble(flDouble data)
{
	_write(&data, sizeof(flDouble));
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeInt64(flInt64 data)
{
	_write(&data, sizeof(flInt64));
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeUInt64(flUInt64 data)
{
	_write(&data, sizeof(flUInt64));
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeBool(const flBool* data, flUInt length)
{
	_write(data, sizeof(flBool) * length);
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeChar(const flChar* data, flUInt length)
{
	_write(data, sizeof(flChar) * length);
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeByte(const flByte* data, flUInt length)
{
	_write(data, sizeof(flByte) * length);
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeShort(const flShort* data, flUInt length)
{
	_write(data, sizeof(flShort) * length);
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeUShort(const flUShort* data, flUInt length)
{
	_write(data, sizeof(flUShort) * length);
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeInt(const flInt* data, flUInt length)
{
	_write(data, sizeof(flInt) * length);
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeUInt(const flUInt* data, flUInt length)
{
	_write(data, sizeof(flUInt) * length);
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeLong(const flLong* data, flUInt length)
{
	_write(data, sizeof(flLong) * length);
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeULong(const flULong* data, flUInt length)
{
	_write(data, sizeof(flULong) * length);
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeFloat(const flFloat* data, flUInt length)
{
	_write(data, sizeof(flFloat) * length);
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeDouble(const flDouble* data, flUInt length)
{
	_write(data, sizeof(flDouble) * length);
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeInt64(const flInt64* data, flUInt length)
{
	_write(data, sizeof(flInt64) * length);
}
//------------------------------------------------------------------------------
void
flOutputByteStream::writeUInt64(const flUInt64* data, flUInt length)
{
	_write(data, sizeof(flUInt64) * length);
}
//------------------------------------------------------------------------------
void
flOutputByteStream::_write(const void *data, size_t length)
{
	if (length == 0)
		return ;

	while(_bufferSize < _size + length)
	{
		_bufferSize += _growSize;
		flChar* newBuffer = new flChar[_bufferSize];

		if (_buffer != NULL)
		{
			memcpy(newBuffer, _buffer, _size);
			delete _buffer;
		}
		_buffer = newBuffer;
	}

	memcpy(_buffer + _size, data, length);

	_size += length;
}
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// flOutputByteStream
flInputByteStream::flInputByteStream()
{
	_array = NULL;
	_index = 0;
}
//------------------------------------------------------------------------------
flInputByteStream::~flInputByteStream()
{
}
//------------------------------------------------------------------------------
void
flInputByteStream::reset()
{
	_index = 0;
}
//------------------------------------------------------------------------------
void
flInputByteStream::set(const flChar* array, flUInt size)
{
	_array = array;
	_size = size;
	_index = 0;
}
//------------------------------------------------------------------------------
flBool
flInputByteStream::endOfStream() const
{
	return (_size == _index);
}
//------------------------------------------------------------------------------
void
flInputByteStream::readBool(flBool& data)
{
	_read(&data, sizeof(flBool));
}
//------------------------------------------------------------------------------
void
flInputByteStream::readChar(flChar& data)
{
	_read(&data, sizeof(flChar));
}
//------------------------------------------------------------------------------
void
flInputByteStream::readByte(flByte& data)
{
	_read(&data, sizeof(flByte));
}
//------------------------------------------------------------------------------
void
flInputByteStream::readShort(flShort& data)
{
	_read(&data, sizeof(flShort));
}
//------------------------------------------------------------------------------
void
flInputByteStream::readUShort(flUShort& data)
{
	_read(&data, sizeof(flUShort));
}
//------------------------------------------------------------------------------
void
flInputByteStream::readInt(flInt& data)
{
	_read(&data, sizeof(flInt));
}
//------------------------------------------------------------------------------
void
flInputByteStream::readUInt(flUInt& data)
{
	_read(&data, sizeof(flUInt));
}
//------------------------------------------------------------------------------
void
flInputByteStream::readLong(flLong& data)
{
	_read(&data, sizeof(flLong));
}
//------------------------------------------------------------------------------
void
flInputByteStream::readULong(flULong& data)
{
	_read(&data, sizeof(flULong));
}
//------------------------------------------------------------------------------
void
flInputByteStream::readFloat(flFloat& data)
{
	_read(&data, sizeof(flFloat));
}
//------------------------------------------------------------------------------
void
flInputByteStream::readDouble(flDouble& data)
{
	_read(&data, sizeof(flDouble));
}
//------------------------------------------------------------------------------
void
flInputByteStream::readInt64(flInt64& data)
{
	_read(&data, sizeof(flInt64));
}
//------------------------------------------------------------------------------
void
flInputByteStream::readUInt64(flUInt64& data)
{
	_read(&data, sizeof(flUInt64));
}
//------------------------------------------------------------------------------
void
flInputByteStream::readBool(flBool* data, flUInt length)
{
	_read(data, sizeof(flBool) * length);
}
//------------------------------------------------------------------------------
void
flInputByteStream::readChar(flChar* data, flUInt length)
{
	_read(data, sizeof(flChar) * length);
}
//------------------------------------------------------------------------------
void
flInputByteStream::readByte(flByte* data, flUInt length)
{
	_read(data, sizeof(flByte) * length);
}
//------------------------------------------------------------------------------
void
flInputByteStream::readShort(flShort* data, flUInt length)
{
	_read(data, sizeof(flShort) * length);
}
//------------------------------------------------------------------------------
void
flInputByteStream::readUShort(flUShort* data, flUInt length)
{
	_read(data, sizeof(flUShort) * length);
}
//------------------------------------------------------------------------------
void
flInputByteStream::readInt(flInt* data, flUInt length)
{
	_read(data, sizeof(flInt) * length);
}
//------------------------------------------------------------------------------
void
flInputByteStream::readUInt(flUInt* data, flUInt length)
{
	_read(data, sizeof(flUInt) * length);
}
//------------------------------------------------------------------------------
void
flInputByteStream::readLong(flLong* data, flUInt length)
{
	_read(data, sizeof(flLong) * length);
}
//------------------------------------------------------------------------------
void
flInputByteStream::readULong(flULong* data, flUInt length)
{
	_read(data, sizeof(flULong) * length);
}
//------------------------------------------------------------------------------
void
flInputByteStream::readFloat(flFloat* data, flUInt length)
{
	_read(data, sizeof(flFloat) * length);
}
//------------------------------------------------------------------------------
void
flInputByteStream::readDouble(flDouble* data, flUInt length)
{
	_read(data, sizeof(flDouble) * length);
}
//------------------------------------------------------------------------------
void
flInputByteStream::readInt64(flInt64* data, flUInt length)
{
	_read(data, sizeof(flInt64) * length);
}
//------------------------------------------------------------------------------
void
flInputByteStream::readUInt64(flUInt64* data, flUInt length)
{
	_read(data, sizeof(flUInt64) * length);
}
//------------------------------------------------------------------------------
void
flInputByteStream::_read(void *data, size_t length)
{
	assert(_array != NULL);

	if (length == 0)
		return ;

	memcpy(data, _array + _index, length);
	_index += length;

	assert(_index <= _size);
}
//------------------------------------------------------------------------------
