/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flByteStream_h__
#define __flByteStream_h__
//------------------------------------------------------------------------------
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class flOutputByteStream
{
public:
	flOutputByteStream();
	virtual ~flOutputByteStream();

public:
	void			reset();
	void			get(const flChar*& data, flUInt& size);

public:
	void			setGrowSize(flUInt size);
	flUInt			getGrowSize() const;

public:
	void			writeBool(flBool data);
	void			writeChar(flChar data);
	void			writeByte(flByte data);
	void			writeShort(flShort data);
	void			writeUShort(flUShort data);
	void			writeInt(flInt data);
	void			writeUInt(flUInt data);
	void			writeLong(flLong data);
	void			writeULong(flULong data);
	void			writeFloat(flFloat data);
	void			writeDouble(flDouble data);
	void			writeInt64(flInt64 data);
	void			writeUInt64(flUInt64 data);

	void			writeBool(const flBool* data, flUInt length);
	void			writeChar(const flChar* data, flUInt length);
	void			writeByte(const flByte* data, flUInt length);
	void			writeShort(const flShort* data, flUInt length);
	void			writeUShort(const flUShort* data, flUInt length);
	void			writeInt(const flInt* data, flUInt length);
	void			writeUInt(const flUInt* data, flUInt length);
	void			writeLong(const flLong* data, flUInt length);
	void			writeULong(const flULong* data, flUInt length);
	void			writeFloat(const flFloat* data, flUInt length);
	void			writeDouble(const flDouble* data, flUInt length);
	void			writeInt64(const flInt64* data, flUInt length);
	void			writeUInt64(const flUInt64* data, flUInt length);

private:
	void			_write(const void *data, size_t length);

protected:
	flUInt			_growSize;

	flUInt			_size;
	flChar*			_buffer;
	flUInt			_bufferSize;
};
//------------------------------------------------------------------------------
class flInputByteStream
{
public:
	flInputByteStream();
	virtual ~flInputByteStream();

public:
	void			reset();
	void			set(const flChar* array, flUInt size);
	flBool			endOfStream() const;

public:
	void			readBool(flBool& data);
	void			readChar(flChar& data);
	void			readByte(flByte& data);
	void			readShort(flShort& data);
	void			readUShort(flUShort& data);
	void			readInt(flInt& data);
	void			readUInt(flUInt& data);
	void			readLong(flLong& data);
	void			readULong(flULong& data);
	void			readFloat(flFloat& data);
	void			readDouble(flDouble& data);
	void			readInt64(flInt64& data);
	void			readUInt64(flUInt64& data);

	void			readBool(flBool* data, flUInt length);
	void			readChar(flChar* data, flUInt length);
	void			readByte(flByte* data, flUInt length);
	void			readShort(flShort* data, flUInt length);
	void			readUShort(flUShort* data, flUInt length);
	void			readInt(flInt* data, flUInt length);
	void			readUInt(flUInt* data, flUInt length);
	void			readLong(flLong* data, flUInt length);
	void			readULong(flULong* data, flUInt length);
	void			readFloat(flFloat* data, flUInt length);
	void			readDouble(flDouble* data, flUInt length);
	void			readInt64(flInt64* data, flUInt length);
	void			readUInt64(flUInt64* data, flUInt length);

private:
	void			_read(void *data, size_t length);

protected:
	const flChar*	_array;
	flUInt			_size;

	flUInt			_index;
};
//------------------------------------------------------------------------------
#endif //__flByteStream_h__
