/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef	__flFuncs_h__
#define	__flFuncs_h__
//------------------------------------------------------------------------------
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
template<class T>
struct flLessFunc
{
	flInt	operator ()(const T* data1, const T* data2) const
	{
		if (*data1 < *data2) return -1;
		else if (*data1 > *data2) return 1;
		return 0;
	}
};
//------------------------------------------------------------------------------
template<class T>
struct flGreaterFunc
{
	flInt	operator ()(const T* data1, const T* data2) const
	{
		if (*data1 < *data2) return 1;
		else if (*data1 > *data2) return -1;
		return 0;
	}
};
//------------------------------------------------------------------------------
template<class T>
struct flCopyFunc
{
	void	operator ()(T* dst, const T* src, flUInt num) const
	{ memcpy(dst, src, sizeof(T)*num); }
};
//------------------------------------------------------------------------------
template<class T>
struct flCompFunc
{
	flBool	operator ()(const T* dst, const T* src, flUInt num) const
	{ return memcmp(dst, src, sizeof(T)*num) == 0; }
};
//------------------------------------------------------------------------------
template<class T>
struct flKeyHashFunc
{
	flUInt	operator ()(const T& key) const { return flUInt(key); }
};
//------------------------------------------------------------------------------
template<class T>
struct flKeyCompFunc
{
	flBool	operator ()(const T& key1, const T& key2) const
	{ return key1 == key2; }
};
//------------------------------------------------------------------------------
#define	FL_DECLARE_SAFE_COPYFUNC(type)										\
template<>																	\
struct flCopyFunc<type>														\
{																			\
	void	operator ()(type* dst, const type* src, flUInt num) const		\
	{ for (flUInt i = 0; i < num; ++i) dst[i] = src[i]; }					\
}
//------------------------------------------------------------------------------
#define	FL_DECLARE_SAFE_COMPFUNC(type)										\
template<>																	\
struct flCompFunc<type>														\
{																			\
	flBool	operator ()(const type* dst, const type* src, flUInt num) const	\
	{																		\
		for (flUInt i = 0; i < num; ++i)									\
		{																	\
			if (dst[i] != src[i])											\
				return false;												\
		}																	\
		return true;														\
	}																		\
}
//------------------------------------------------------------------------------
#endif	// !__flFuncs_h__
