//------------------------------------------------------------------------------
#ifndef	__flHash_h__
#define	__flHash_h__
//------------------------------------------------------------------------------
#include <flBase/flArray.h>
//------------------------------------------------------------------------------
template<class K,
		 class V,
		 class HF=flKeyHashFunc<K>,
		 class CF=flKeyCompFunc<K> >
class flHashMap
{
public:
	// should set a prime number as table size
	static const flUInt	DEFAULT_TABLESIZE = 101;

	flHashMap(flUInt tableSize = DEFAULT_TABLESIZE);
	flHashMap(const flHashMap& hashMap);
	~flHashMap();

public:
	void			copy(const flHashMap& hashMap);
	flBool			equal(const flHashMap& hashMap) const;

	void			clear();
	flUInt			getSize() const;
	flUInt			getTableSize() const;
	flBool			resizeTable(flUInt newTableSize);

	void			insert(const K& key, const V& value);
	flBool			get(const K& key, V& value) const;
	flBool			find(const K& key) const;
	void			remove(const K& key);
	void			replace(const K& key, const V& newValue);

	const K&		getKey(flUInt index) const;
	const V&		getValue(flUInt index) const;

public:
	flBool			operator ==(const flHashMap& hashMap) const;
	flBool			operator !=(const flHashMap& hashMap) const;

	flHashMap&		operator =(const flHashMap& hashMap);

#ifdef	_DEBUG
public:
	void			postInformation() const;
#endif

private:
	flUInt			_tableSize;
	flArray<K>*		_keyTable;
	flArray<V>*		_valueTable;
};
//------------------------------------------------------------------------------
#include <flBase/flHash.inl>
//------------------------------------------------------------------------------
//	sample prime number table(<1000)
// 2 79 191 311 439 577 709 857 
// 3 83 193 313 443 587 719 859 
// 5 89 197 317 449 593 727 863 
// 7 97 199 331 457 599 733 877 
// 11 101 211 337 461 601 739 881 
// 13 103 223 347 463 607 743 883 
// 17 107 227 349 467 613 751 887 
// 19 109 229 353 479 617 757 907 
// 23 113 233 359 487 619 761 911 
// 29 127 239 367 491 631 769 919 
// 31 131 241 373 499 641 773 929 
// 37 137 251 379 503 643 787 937 
// 41 139 257 383 509 647 797 941 
// 43 149 263 389 521 653 809 947 
// 47 151 269 397 523 659 811 953 
// 53 157 271 401 541 661 821 967 
// 59 163 277 409 547 673 823 971 
// 61 167 281 419 557 677 827 977 
// 67 173 283 421 563 683 829 983 
// 71 179 293 431 569 691 839 991 
// 73 181 307 433 571 701 853 997 
//------------------------------------------------------------------------------
#endif	// !__flHash_h__
