/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef	__flImage_h__
#define	__flImage_h__
//------------------------------------------------------------------------------
#include <flBase/flArray.h>
//------------------------------------------------------------------------------
class flImage;
typedef flArray<flImage>	flImageArray;
//------------------------------------------------------------------------------
class flImage
{
public:
	flImage();
	flImage(const flImage& p);
	flImage(flUInt width, flUInt height,
		flUInt components, const flByte* image);
	~flImage();

public:
	void			copy(const flImage& p);
	flBool			equal(const flImage& p) const;

	void			set(flUInt width,
						flUInt height,
						flUInt components,
						const flByte* image);
	flBool			isValid() const;

	flUInt			width() const;
	flUInt			height() const;
	flUInt			components() const;
	const flByte*	image() const;

	flUInt			getSize() const;
	flBool			isTransparent() const;

	void			clear();
	void			swapColor();

	enum AlignEnum {
		A_NONE		= 0x00000000,
		A_LEFT		= 0x00000001,
		A_RIGHT		= 0x00000002,
		A_TOP		= 0x00000004,
		A_BOTTOM	= 0x00000008
	};
	void			resize(flUInt width, flUInt height, AlignEnum align = A_NONE);
	void			stretch(flUInt width, flUInt height);

	flUInt			hash() const;

public:
	flImage&		operator =(const flImage& p);
	
	friend flBool	operator ==(const flImage& i1, const flImage& i2);
	friend flBool	operator !=(const flImage& i1, const flImage& i2);
private:
	flUInt			_width;
	flUInt			_height;
	flUInt			_components;
	flByte*			_image;
};
//------------------------------------------------------------------------------
DECLARE_SAFE_COPYFUNC(flImage);
DECLARE_SAFE_COMPFUNC(flImage);
//------------------------------------------------------------------------------
template<>
struct flKeyHashFunc<flImage>
{
	flUInt			operator ()(const flImage& key) const
	{
		return key.hash();
	}
};
//------------------------------------------------------------------------------
#include <flBase/flImage.inl>
//------------------------------------------------------------------------------
#endif	// !__flImage_h__
