/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef	__flImageIO_h__
#define	__flImageIO_h__
//------------------------------------------------------------------------------
#include <flBase/flImage.h>
#include <flBase/flString.h>
//------------------------------------------------------------------------------
class flImageIO
{
public:
	flImageIO();
	virtual ~flImageIO();

public:
	const flImage	load(const flString& filename) const;
	const flImage	loadJPEG(const flString& filename) const;
	const flImage	loadBMP(const flString& filename) const;
	const flImage	loadPPM(const flString& filename) const;
	const flImage	loadTGA(const flString& filename) const;
	const flImage	loadPNG(const flString& filename) const;
	const flImage	loadTIFF(const flString& filename) const;
	const flImage	loadRGB(const flString& filename) const;

	flBool			save(const flString& filename,
						const flImage& image) const;
	flBool			saveJPEG(const flString& filename,
						const flImage& image) const;
	flBool			saveBMP(const flString& filename,
						const flImage& image) const;
	flBool			savePNG(const flString& filename,
						const flImage& image) const;

};
//------------------------------------------------------------------------------
#endif	// !__flImageIO_h__
