/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef	__flList_h__
#define	__flList_h__
//------------------------------------------------------------------------------
#include <flBase/flFuncs.h>
//------------------------------------------------------------------------------
template<class T,
		 class LF=flLessFunc<T>,
		 class GF=flGreaterFunc<T>,
		 class CPF=flCopyFunc<T>,
		 class CMF=flCompFunc<T> >
class flList
{
private:
	template<class T>
	class flListNode
	{
		friend class flList;
	public:
		flListNode() : _prev(NULL), _next(NULL) {}
		flListNode(const T& value) : _next(NULL), _prev(NULL) { set(value); }

	public:
		void		set(const T& value) { _value = value; }
		T&			get() { return _value; }
		const T&	get() const { return _value; }

		void		setPrev(flListNode* v) { _prev = v; }
		flListNode*	getPrev() const { return _prev; }
		void		setNext(flListNode* v) { _next = v; }
		flListNode*	getNext() const { return _next; }

	private:
		flListNode*	_prev;
		flListNode*	_next;
		T			_value;
	};

public:
	template<class T>
	class flIterator
	{
		friend class flList;
	public:
		flIterator() : _nodePtr(NULL) {}
		flIterator(flListNode<T>* value) : _nodePtr(value) {}
		flIterator(const flIterator& i) : _nodePtr(i._nodePtr) {}

	public:
		flIterator&	operator ++()
		{ _nodePtr = _nodePtr->getNext(); return *this; }
		flIterator	operator ++(flInt)
		{ flIterator tmp(*this); ++(*this); return tmp; }
		flIterator&	operator --()
		{ _nodePtr = _nodePtr->getPrev(); return *this; }
		flIterator	operator --(flInt)
		{ flIterator tmp(*this); --(*this); return tmp; }

		T&			operator *() { return _nodePtr->get(); }
		const T&	operator *() const { return _nodePtr->get(); }

		flBool		operator ==(const flIterator& i) const
		{ return _nodePtr == i._nodePtr; }
		flBool		operator !=(const flIterator& i) const
		{ return _nodePtr != i._nodePtr; }

	private:
		flListNode<T>*	_nodePtr;
	};

	typedef flIterator<T>	iterator;

public:
	typedef flInt (*SortFunc)(const T*, const T*);

	flList();
	flList(const flList& list);
	~flList();

public:
	void			copy(const flList& list);
	flBool			equal(const flList& list) const;

	void			clear();

	flUInt			getSize() const;

	void			add(const T& v);
	flBool			find(const T& v) const;
	void			remove(const T& v);
	void			removeAll(const T& v);

	iterator		begin() const;
	iterator		end() const;

	void			sortLess();
	void			sortGreater();
	void			sort(SortFunc lessFunc);

public:
	flBool			operator ==(const flList& list) const;
	flBool			operator !=(const flList& list) const;

	flList&			operator =(const flList& list);

	T&				operator[](flUInt i);
	const T&		operator[](flUInt i) const;
	
private:
	flListNode<T>*	_dummy;
	flListNode<T>*	_last;
	flUInt			_size;
};
//------------------------------------------------------------------------------
#include <flBase/flList.inl>
//------------------------------------------------------------------------------
#endif	// !__flList_h__
