/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef	__flList_inl__
#define	__flList_inl__
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
flList<T, LF, GF, CPF, CMF>::flList() :
_dummy(NULL),
_last(NULL),
_size(0)
{
	_dummy = new flListNode<T>;
	_dummy->setNext(_dummy);
	_dummy->setPrev(_dummy);
	_last = _dummy;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
flList<T, LF, GF, CPF, CMF>::flList(const flList& list) :
_dummy(NULL),
_last(NULL),
_size(0)
{
	_dummy = new flListNode<T>;
	_dummy->setNext(_dummy);
	_dummy->setPrev(_dummy);
	_last = _dummy;
	copy(list);
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
flList<T, LF, GF, CPF, CMF>::~flList()
{
	clear();
	delete _dummy;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flList<T, LF, GF, CPF, CMF>::copy(const flList& list)
{
	if (this == &list)
		return;

	clear();
	flListNode<T>* value = list._dummy->getNext();
	for (; value != list._dummy; value = value->getNext())
		add(value->get());
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
flBool
flList<T, LF, GF, CPF, CMF>::equal(const flList& list) const
{
	if (this == &list)
		return true;

	if (_size != list._size)
		return false;

	flListNode<T>* value1 = _dummy->getNext();
	flListNode<T>* value2 = list._dummy->getNext();
	for (; value1 != _dummy; value1 = value1->getNext(), value2 = value2->getNext())
	{
		if (value1 != value2)
			return false;
	}
	return true;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flList<T, LF, GF, CPF, CMF>::clear()
{
	flListNode<T>* value = _dummy->getNext();
	flListNode<T>* next = NULL;
	for (; value != _dummy; value = next)
	{
		next = value->getNext();
		delete value;
	}
	_last = _dummy;
	_dummy->setNext(_dummy);
	_dummy->setPrev(_dummy);
	_size = 0;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
inline flUInt
flList<T, LF, GF, CPF, CMF>::getSize() const
{
	return _size;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flList<T, LF, GF, CPF, CMF>::add(const T& v)
{
	flListNode<T>* value = new flListNode<T>(v);
	_last->setNext(value);
	value->setPrev(_last);
	value->setNext(_dummy);
	_last = value;
	_dummy->setPrev(_last);
	++_size;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
flBool
flList<T, LF, GF, CPF, CMF>::find(const T& v) const
{
	flListNode<T>* value = _dummy->getNext();
	for (; value != _dummy; value = value->getNext())
	{
		if (value->get() == v)
			return true;
	}
	return false;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flList<T, LF, GF, CPF, CMF>::remove(const T& v)
{
	flListNode<T>* value = _dummy->getNext();
	for (; value != _dummy; value = value->getNext())
	{
		if (value->get() == v)
		{
			flListNode<T>* prev = value->getPrev();
			flListNode<T>* next = value->getNext();
			prev->setNext(next);
			next->setPrev(prev);
			delete value;
			--_size;
			break;
		}
	}
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flList<T, LF, GF, CPF, CMF>::removeAll(const T& v)
{
	flListNode<T>* value = _dummy->getNext();
	for (; value != _dummy; value = value->getNext())
	{
		if (value->get() == v)
		{
			flListNode<T>* prev = value->getPrev();
			flListNode<T>* next = value->getNext();
			prev->setNext(next);
			next->setPrev(prev);
			delete value;
			--_size;
			value = prev;
		}
	}
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
inline typename flList<T, LF, GF, CPF, CMF>::iterator
flList<T, LF, GF, CPF, CMF>::begin() const
{
	return iterator(_dummy->getNext());
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
inline typename flList<T, LF, GF, CPF, CMF>::iterator
flList<T, LF, GF, CPF, CMF>::end() const
{
	return iterator(_dummy);
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
inline flBool
flList<T, LF, GF, CPF, CMF>::operator ==(const flList& list) const
{
	return equal(list);
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
inline flBool
flList<T, LF, GF, CPF, CMF>::operator !=(const flList& list) const
{
	return !equal(list);
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
inline flList<T, LF, GF, CPF, CMF>&
flList<T, LF, GF, CPF, CMF>::operator =(const flList& list)
{
	copy(list);
	return *this;
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
T&
flList<T, LF, GF, CPF, CMF>::operator[](flUInt i)
{
	flUInt counter = 0;
	flListNode<T>* value = _dummy->getNext();
	for (; value != _dummy; value = value->getNext(), ++counter)
	{
		if (counter == i)
			return value->get();
	}
	return _dummy->get();
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
const T&
flList<T, LF, GF, CPF, CMF>::operator[](flUInt i) const
{
	flUInt counter = 0;
	flListNode<T>* value = _dummy->getNext();
	for (; value != _dummy; value = value->getNext(), ++counter)
	{
		if (counter == i)
			return value->get();
	}
	return _dummy->get();
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flList<T, LF, GF, CPF, CMF>::sortLess()
{
	if (_size > 1)
	{
		flArray<T, LF, GF, CPF, CMF> array;
		array.setBufferSize(_size+1);
		flListNode<T>* value = _dummy->getNext();
		for (; value != _dummy; value = value->getNext())
			array.add(value->get());
		array.sortLess();
		clear();
		for (flUInt i = 0; i < array.getSize(); ++i)
			add(array[i]);
	}
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flList<T, LF, GF, CPF, CMF>::sortGreater()
{
	if (_size > 1)
	{
		flArray<T, LF, GF, CPF, CMF> array(_size);
		flListNode<T>* value = _dummy->getNext();
		for (; value != _dummy; value = value->getNext())
			array.add(value->get());
		array.sortGreater();
		clear();
		for (flUInt i = 0; i < array.getSize(); ++i)
			add(array[i]);
	}
}
//------------------------------------------------------------------------------
template<class T, class LF, class GF, class CPF, class CMF>
void
flList<T, LF, GF, CPF, CMF>::sort(SortFunc sortFunc)
{
	if (_size > 1)
	{
		flArray<T, LF, GF, CPF, CMF> array(_size);
		flListNode<T>* value = _dummy->getNext();
		for (; value != _dummy; value = value->getNext())
			array.add(value->get());
		array.sort((flArray<T, LF, GF, CPF, CMF>::SortFunc)sortFunc);
		clear();
		for (flUInt i = 0; i < array.getSize(); ++i)
			add(array[i]);
	}
}
//------------------------------------------------------------------------------
#endif	// !__flList_inl__
