/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "StdAfx.h"
#include <flBase/flNotify.h>
#include <cstdio>
//------------------------------------------------------------------------------
static const flChar* LEVEL_STR[] =
{
	"[Error]",
	"[Warn]",
	"[Notice]",
	"[Info]",
	"[Fatal]",
	"[Debug]",
	NULL
};
static const flChar OUTPUT_FILENAME[] =
{
	"errorlog.txt"
};
//------------------------------------------------------------------------------
flNotify::OutputEnum	flNotify::_output =	flNotify::DEFAULT_OUTPUT;
//------------------------------------------------------------------------------
void
flNotify::post(LevelEnum level, const flChar* format...)
{
	flChar msg[256], buf[256];

	if (level >= L_ERR && level <= L_DEBUG)
		sprintf(msg, "%s : ", LEVEL_STR[level]);
	else
		strcpy(msg, "[Unknown] : ");

	va_list	args;
	va_start(args, format);
	vsprintf(buf, format, args);
	va_end(args);
	strcat(msg, buf);
	strcat(msg, "\n");

	switch (_output)
	{
	case TO_CONSOLE:
#ifndef _WIN32
	case TO_DEBUGWINDOW:
#endif
		fprintf(stderr, "%s", msg);
		break;

	case TO_FILE:
		{
			FILE* fp = fopen(OUTPUT_FILENAME, "a");
			if (fp)
			{
				fprintf(fp, "%s", msg);
				fclose(fp);
			}
		}
		break;

#ifdef _WIN32
	case TO_DEBUGWINDOW:
		OutputDebugString(msg);
		break;
#endif
	}
}
//------------------------------------------------------------------------------
void
flNotify::post(LevelEnum level, const flString& str)
{
	flString msg;

	if (level >= L_ERR && level <= L_DEBUG)
	{
		msg = LEVEL_STR[level];
		msg += " : ";
	}
	else
		msg = "[Unknown] : ";

	msg += str;
	msg += "\n";

	switch (_output) {
	case TO_CONSOLE:
#ifndef _WIN32
	case TO_DEBUGWINDOW:
#endif
		fprintf(stderr, "%s", msg.c_str());
		break;

	case TO_FILE:
		{
			FILE* fp = fopen(OUTPUT_FILENAME, "a");
			if (fp)
			{
				fprintf(fp, "%s", msg.c_str());
				fclose(fp);
			}
		}
		break;

#ifdef _WIN32
	case TO_DEBUGWINDOW:
		OutputDebugString(msg.c_str());
		break;
#endif
	}
}
//------------------------------------------------------------------------------
