/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef	__flNotify_h__
#define	__flNotify_h__
//------------------------------------------------------------------------------
#include <flBase/flString.h>
//------------------------------------------------------------------------------
class flNotify
{
public:
	enum OutputEnum
	{
		TO_CONSOLE,
		TO_FILE,
		TO_DEBUGWINDOW,

#ifdef _WIN32
		DEFAULT_OUTPUT = TO_DEBUGWINDOW
#else
		DEFAULT_OUTPUT = TO_CONSOLE
#endif
	};

	enum LevelEnum
	{
		L_ERR,
		L_WARN,
		L_NOTICE,
		L_INFO,
		L_FATAL,
		L_DEBUG
	};

public:
	static void			setOutput(OutputEnum output) { _output = output; }
	static OutputEnum	getOutput() { return _output; }

	static void			post(LevelEnum level, const flChar* format...);
	static void			post(LevelEnum level, const flString& str);

private:
	flNotify();

private:
	static OutputEnum	_output;
};
//------------------------------------------------------------------------------
#endif	// !__flNotify_h__
