/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "StdAfx.h"
#include <flBase/flQuickSort.h>
//------------------------------------------------------------------------------
const size_t	BUF_SIZE = 256;	// > 0, auto obt@̑傫
const size_t	SORT_MAX = 32;	// > 1, }ւ̐؂ւ_
//------------------------------------------------------------------------------
static void
swap(flChar* qb, flChar* qe, size_t size)
{	// vf *qb , *qe ̌
	flChar buf[BUF_SIZE];	// p̒u
	size_t ms;

	for (ms = size; 0 < ms; )
	{	// ł邾
		size_t m = ms < sizeof(buf) ? ms : sizeof(buf);
		memcpy(buf, qb, m);
		memcpy(qb, qe, m);
		memcpy(qe, buf, m);
		ms -= m, qb += m, qe += m;
	}
}
//------------------------------------------------------------------------------
static void
rotate(flChar* qb, flChar* qe, size_t size)
{	// [*qb, *qe] 1E]
	flChar buf[BUF_SIZE];	// ]pu
	size_t ms, mtot = qe - qb + size;

	for (ms = size; 0 < ms; )
	{	// ł邾]
		size_t m = ms < sizeof(buf) ? ms : sizeof(buf);
		memcpy(buf, qe + (size - m), m);
		memmove(qb + m, qb, mtot - m);
		memcpy(qb, buf, m);
		ms -= m;
	}
}
//------------------------------------------------------------------------------
static void
adjustHeap(flChar* qb, size_t h, size_t n, size_t size,
		   flQuickSort::SortFunc compare)
{	// q[v (flChar qb[size])[n]  h ŃACeăq[v
	size_t h0 = h;
	size_t k = 2 * h + 2;
	flChar* qh = qb + h * size;
	flChar* qk = qb + k * size;

	for (; k <= n; k = 2 * k + 2, qk = qb + k * size)
	{	// qǂ̂ݏ[ȑ傫̌
		if (k == n || compare(qk, qk - size) < 0)
			--k, qk -= size;
		swap(qh, qk, size);
		h = k, qh = qk;
	}

	for (; h0 < h; )
	{	// h0 ܂ł̌
		size_t i = (h - 1) / 2;
		flChar* qi = qb + i * size;
		if (compare(qh, qi) <= 0)
			break;
		swap(qi, qh, size);
		h = i, qh = qi;
	}
}
//------------------------------------------------------------------------------
static void
introSort(flChar* qb, size_t n, size_t ideal, size_t size,
		  flQuickSort::SortFunc compare)
{	// ċAIɐ
	for (; 0 < ideal && SORT_MAX < n; )
	{	// r{bgɂNCbN\[g
		size_t m = n / 2;
		flChar* qm = qb + m * size;
		flChar* qf = qb;
		flChar* ql = qb + n * size;

		if (compare(qm, qf) < 0)
			swap(qf, qm, size);
		if (compare(ql - size, qm) < 0)
			swap(qm, ql - size, size);
		if (compare(qm, qf) < 0)
			swap(qf, qm, size);

		for (; ; qf += size)
		{ // r{bglɂ蕪
			for (; qf < ql && compare(qf, qm) <= 0; qf += size)
				;
			for (; qb < ql && compare(qm, ql -= size) <= 0; )
				;
			if (ql <= qf)
				break;

			swap(qf, ql, size);
			if (qm == qf)
				qm = ql;
			else if (qm == ql)
				qm = qf;
		}
		ideal /= 2, ideal += ideal / 2;
		m = (ql - qb) / size + 1;
		n -= (qf - qb) / size;
		if (m <= n)
			introSort(qb, m, ideal, size, compare), qb = qf;
		else
			introSort(qf, n, ideal, size, compare), n = m;
	}

	if (SORT_MAX < n)
	{ // q[v\[g
		size_t h;
		flChar* qe;
		for (h = n / 2; 0 < h; )
			adjustHeap(qb, --h, n, size, compare);
		for (qe = qb + n * size; 1 < n; )
		{ // ővf𖖔Ƀ|bv
			swap(qb, qe -= size, size);
			adjustHeap(qb, 0, --n, size, compare);
		}
	}
	else if (1 < n)
	{ // }
		flChar* qm;
		for (qm = qb; 0 < --n; )
		{ // vf [2, n) ܂Ō
			qm += size;
			if (compare(qm, qb) < 0)
				rotate(qb, qm, size);
			else
			{ // tɃXL
				flChar* qx = qm,* qx0 = qm;
				for (; compare(qm, qx0 -= size) < 0; qx = qx0)
					;
				if (qx != qm)
					rotate(qx, qm, size);
			}
		}
	}
}
//------------------------------------------------------------------------------
void
flQuickSort::sort(void* base, size_t num, size_t size, SortFunc compare)
{
	// Cg\[gg (flChar base[size])[n] 𐮗
	introSort((flChar*)base, num, num, size, compare);
}
//------------------------------------------------------------------------------
