/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "StdAfx.h"
#include <flBase/flString.h>
#include <cstdio>
//------------------------------------------------------------------------------
flString::flString(flInt intString) :
_string(NULL)
{
	flChar buf[32];
	sprintf(buf, "%d", intString);
	_string = new flChar[strlen(buf)+1];
	strcpy(_string, buf);
}
//------------------------------------------------------------------------------
flString::flString(flFloat floatString) :
_string(NULL)
{
	flChar buf[32];
	sprintf(buf, "%f", floatString);
	_string = new flChar[strlen(buf)+1];
	strcpy(_string, buf);
}
//------------------------------------------------------------------------------
flString::flString(flDouble doubleString) :
_string(NULL)
{
	flChar buf[32];
	sprintf(buf, "%lf", doubleString);
	_string = new flChar[strlen(buf)+1];
	strcpy(_string, buf);
}
//------------------------------------------------------------------------------
flString::~flString()
{
	makeEmpty();
}
//------------------------------------------------------------------------------
flUInt
flString::length() const
{
	return (_string != NULL) ? (flUInt)strlen(_string) : 0;
}
//------------------------------------------------------------------------------
void
flString::length(flUInt len)
{
	if (len == 0)
	{
		makeEmpty();
	}
	else
	{
		flUInt	aLen = length();
		flChar*	newStr = new flChar[len+1];
		memset(newStr, 0, len+1);
		if (_string != NULL)
			memcpy(newStr, _string, (aLen<len) ? aLen : len);
		makeEmpty();
		_string = newStr;
	}
}
//------------------------------------------------------------------------------
flBool
flString::isEmpty() const
{
	return (_string == NULL) || (*_string == '\0');
}
//------------------------------------------------------------------------------
void
flString::makeEmpty()
{
	delete [] _string;
	_string = NULL;
}
//------------------------------------------------------------------------------
flString
flString::lowerCase() const
{
	flString	str = *this;
	str.toLower();
	return str;
}
//------------------------------------------------------------------------------
flString
flString::upperCase() const
{
	flString	str = *this;
	str.toUpper();
	return str;
}
//------------------------------------------------------------------------------
void
flString::toLower()
{
	if (_string != NULL)
	{
		for (flChar* str = _string; *str; str++)
			*str = (flChar)tolower(*str);
	}
}
//------------------------------------------------------------------------------
void
flString::toUpper()
{
	if (_string != NULL)
	{
		for (flChar* str = _string; *str; str++)
			*str = (flChar)toupper(*str);
	}
}
//------------------------------------------------------------------------------
flInt
flString::toInt(flInt defaultValue) const
{
	if (_string != NULL)
	{
		flInt intString = defaultValue;
		sscanf(_string, "%d", &intString);
		return intString;
	}
	return defaultValue;
}
//------------------------------------------------------------------------------
flFloat
flString::toFloat(flFloat defaultValue) const
{
	if (_string != NULL)
	{
		flFloat floatString = defaultValue;
		sscanf(_string, "%f", &floatString);
		return floatString;
	}
	return defaultValue;
}
//------------------------------------------------------------------------------
flDouble
flString::toDouble(flDouble defaultValue) const
{
	if (_string != NULL)
	{
		flDouble doubleString = defaultValue;
		sscanf(_string, "%lf", &doubleString);
		return doubleString;
	}
	return defaultValue;
}
//------------------------------------------------------------------------------
const flString
flString::subString(flUInt index) const
{
	flUInt aLen = length();
	if (aLen > index)
	{
		flString str(_string+index);
		str.length(aLen-index);
		return str;
	}
	return "";
}
//------------------------------------------------------------------------------
const flString
flString::subString(flUInt index, flUInt count) const
{
	flUInt aLen = length();
	if (aLen >= index + count)
	{
		flString str(_string+index);
		str.length(count);
		return str;
	}
	return "";
}
//------------------------------------------------------------------------------
flString&
flString::insert(const flString& str, flUInt index)
{
	flUInt aLen = length();
	flUInt bLen = str.length();
	if (aLen > index)
	{
		flChar* newStr = new flChar[aLen+bLen+1];
		if (index > 0)
			memcpy(newStr, _string, index);
		newStr[index] = '\0';
		strcat(newStr, str._string);
		strcat(newStr, _string+index);
		makeEmpty();
		_string = newStr;
	}
	return *this;
}
//------------------------------------------------------------------------------
flString&
flString::format(const flChar* format...)
{
	flChar str[512];
	va_list	args;
	va_start(args, format);
	vsprintf(str, format, args);
	va_end(args);
    *this = str;
	return *this;
}
//------------------------------------------------------------------------------
flString&
flString::replace(const flString& oldString, const flString newString)
{
	flChar* sstr = strstr(_string, oldString._string);
	if (sstr != NULL)
	{
		flUInt aLen = length();
		flUInt oLen = oldString.length();
		flUInt nLen = newString.length();
		flUInt sLen = (flUInt)strlen(sstr);

		flChar* newStr = new flChar[aLen-oLen+nLen+1];
		memset(newStr, 0, aLen-oLen+nLen+1);

		if (_string != sstr)
			memcpy(newStr, _string, aLen-sLen);
		strcat(newStr, newString._string);
		if (aLen-sLen+oLen < aLen)
			strcat(newStr, &_string[aLen-sLen+oLen]);

		makeEmpty();
		_string = newStr;
	}
	return *this;
}
//------------------------------------------------------------------------------
flUInt
flString::hash() const
{
	flUInt total = 0, shift = 0;
	if (_string != NULL)
	{
		for (flChar* s = _string; *s; s++)
		{
			total = total ^ ((*s) << shift);
			shift += 5;
			if (shift > 24)
				shift -= 24;
		}
	}
	return total;
}
//------------------------------------------------------------------------------
flString&
flString::operator =(const flChar* str)
{
	flUInt aLen = (str != NULL) ? (flUInt)strlen(str) : 0;
	if (aLen > 0)
	{
		flUInt bLen = length();
		if (str >= _string && str <= _string + bLen + 1)
		{
			flString tmp(str);
			*this = tmp._string;
		}
		else
		{
			makeEmpty();
			_string = new flChar[aLen+1];
			strcpy(_string, str);
		}
	}
	else
	{
		makeEmpty();
	}
	return *this;
}
//------------------------------------------------------------------------------
flString&
flString::operator +=(const flChar* str)
{
	flUInt aLen = (str != NULL) ? (flUInt)strlen(str) : 0;
	if (aLen > 0)
	{
		flUInt bLen = length();
		flChar* newStr = new flChar[aLen+bLen+1];
		if (bLen > 0)
			strcpy(newStr, _string);
		else
			newStr[0] = '\0';
		strcat(newStr, str);
		makeEmpty();
		_string = newStr;
	}
	return *this;
}
//------------------------------------------------------------------------------
const flString __stdcall
operator +(const flString& str1, const flString& str2)
{
	flString newStr(str1);
	newStr += str2._string;
	return newStr;
}
//------------------------------------------------------------------------------
flBool __stdcall
operator ==(const flString& str1, const flChar* str2)
{
	return (str1._string != NULL && str2 != NULL) ?
		((str1._string[0] == str2[0]) &&
		(strcmp(str1._string, str2) == 0)) : false;
}
//------------------------------------------------------------------------------
flBool __stdcall
operator < (const flString& str1, const flChar* str2)
{
	return (str1._string != NULL && str2 != NULL) ?
		strcmp(str1._string, str2) < 0 : false;
}
//------------------------------------------------------------------------------
flBool __stdcall
operator > (const flString& str1, const flChar* str2)
{
	return (str1._string != NULL && str2 != NULL) ?
		strcmp(str1._string, str2) > 0 : false;
}
//------------------------------------------------------------------------------
flBool __stdcall
operator <=(const flString& str1, const flChar* str2)
{
	return (str1._string != NULL && str2 != NULL) ?
		strcmp(str1._string, str2) <= 0 : false;
}
//------------------------------------------------------------------------------
flBool __stdcall
operator >=(const flString& str1, const flChar* str2)
{
	return (str1._string != NULL && str2 != NULL) ?
		strcmp(str1._string, str2) >= 0 : false;
}
//------------------------------------------------------------------------------
