/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef	__flString_h__
#define	__flString_h__
//------------------------------------------------------------------------------
#include <flBase/flArray.h>
//------------------------------------------------------------------------------
class flString;
typedef flArray<flString>	flStringArray;
//------------------------------------------------------------------------------
class flString
{
public:
	flString();
	flString(const flChar* str);
	flString(const flString& str);
	flString(flInt intString);
	flString(flFloat floatString);
	flString(flDouble doubleString);
	~flString();

public:
	const flChar*	c_str() const;

	flUInt			length() const;
	void			length(flUInt len);

	flBool			isEmpty() const;
	void			makeEmpty();

	flString		lowerCase() const;
	flString		upperCase() const;
	void			toLower();
	void			toUpper();

	flInt			toInt(flInt defaultValue = 0) const;
	flFloat			toFloat(flFloat defaultValue = 0) const;
	flDouble		toDouble(flDouble defaultValue = 0) const;

	const flString	subString(flUInt index) const;
	const flString	subString(flUInt index, flUInt count) const;
	flString&		insert(const flString& str, flUInt index);
	flString&		format(const flChar* format...);
	flString&		replace(const flString& oldString, const flString newString);

	flUInt			hash() const;

public:
	flChar&			operator [](const int idx);
	const flChar&	operator [](const int idx) const;

	flString&		operator =(const flChar* str);
	flString&		operator =(const flString& str);

	flString&		operator +=(const flChar* str);
	flString&		operator +=(const flString& str);

	flBool			operator !() const;

	friend const flString __stdcall
		operator +(const flString& str1, const flString& str2);
	friend flBool __stdcall
		operator ==(const flString& str1, const flChar* str2);
	friend flBool __stdcall
		operator ==(const flChar* str1, const flString& str2);
	friend flBool __stdcall
		operator ==(const flString& str1, const flString& str2);

	friend flBool __stdcall
		operator !=(const flString& str1, const flChar* str2);
	friend flBool __stdcall
		operator !=(const flChar* str1, const flString& str2);
	friend flBool __stdcall
		operator !=(const flString& str1, const flString& str2);

	friend flBool __stdcall
		operator < (const flString& str1, const flChar* str2);
	friend flBool __stdcall
		operator < (const flChar* str1, const flString& str2);
	friend flBool __stdcall
		operator < (const flString& str1, const flString& str2);

	friend flBool __stdcall
		operator > (const flString& str1, const flChar* str2);
	friend flBool __stdcall
		operator > (const flChar* str1, const flString& str2);
	friend flBool __stdcall
		operator > (const flString& str1, const flString& str2);

	friend flBool __stdcall
		operator <=(const flString& str1, const flChar* str2);
	friend flBool __stdcall
		operator <=(const flChar* str1, const flString& str2);
	friend flBool __stdcall
		operator <=(const flString& str1, const flString& str2);

	friend flBool __stdcall
		operator >=(const flString& str1, const flChar* str2);
	friend flBool __stdcall
		operator >=(const flChar* str1, const flString& str2);
	friend flBool __stdcall
		operator >=(const flString& str1, const flString& str2);

private:
	flChar*		_string;
};
//------------------------------------------------------------------------------
FL_DECLARE_SAFE_COPYFUNC(flString);
FL_DECLARE_SAFE_COMPFUNC(flString);
//------------------------------------------------------------------------------
template<>
struct flKeyHashFunc<flString>
{
	flUInt	operator ()(const flString& key) const
	{ return key.hash(); }
};
//------------------------------------------------------------------------------
#include <flBase/flString.inl>
//------------------------------------------------------------------------------
#endif	// !__flString_h__
