/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//----------------------------------------------------------------------------
#ifndef	__flString_inl__
#define	__flString_inl__
//----------------------------------------------------------------------------
inline
flString::flString() :
_string(NULL)
{
}
//----------------------------------------------------------------------------
inline
flString::flString(const flChar* str) :
_string(NULL)
{
	*this = str;
}
//----------------------------------------------------------------------------
inline
flString::flString(const flString& str) :
_string(NULL)
{
	*this = str._string;
}
//----------------------------------------------------------------------------
inline const flChar*
flString::c_str() const
{
	return _string;
}
//----------------------------------------------------------------------------
inline flChar&
flString::operator [](const int idx)
{
	return _string[idx];
}
//----------------------------------------------------------------------------
inline const flChar&
flString::operator [](const int idx) const
{
	return _string[idx];
}
//----------------------------------------------------------------------------
inline flString&
flString::operator =(const flString& str)
{
	return *this = str._string;
}
//----------------------------------------------------------------------------
inline flString&
flString::operator +=(const flString& str)
{
	return *this += str._string;
}
//----------------------------------------------------------------------------
inline flBool
flString::operator !() const
{
	return isEmpty();
}
//----------------------------------------------------------------------------
inline flBool __stdcall
operator ==(const flChar* str1, const flString& str2)
{
	return str2 == str1;
}
//----------------------------------------------------------------------------
inline flBool __stdcall
operator ==(const flString& str1, const flString& str2)
{
	return str1 == str2._string;
}
//----------------------------------------------------------------------------
inline flBool __stdcall
operator !=(const flString& str1, const flChar* str2)
{
	return !(str1 == str2);
}
//----------------------------------------------------------------------------
inline flBool __stdcall
operator !=(const flChar* str1, const flString& str2)
{
	return str2 != str1;
}
//----------------------------------------------------------------------------
inline flBool __stdcall
operator !=(const flString& str1, const flString& str2)
{
	return str1 != str2._string;
}
//----------------------------------------------------------------------------
inline flBool __stdcall
operator < (const flChar* str1, const flString& str2)
{
	return str2 >= str1;
}
//----------------------------------------------------------------------------
inline flBool __stdcall
operator < (const flString& str1, const flString& str2)
{
	return str1 < str2._string;
}
//----------------------------------------------------------------------------
inline flBool __stdcall
operator > (const flChar* str1, const flString& str2)
{
	return str2 <= str1;
}
//----------------------------------------------------------------------------
inline flBool __stdcall
operator > (const flString& str1, const flString& str2)
{
	return str1 > str2._string;
}
//----------------------------------------------------------------------------
inline flBool __stdcall
operator <=(const flChar* str1, const flString& str2)
{
	return str2 > str1;
}
//----------------------------------------------------------------------------
inline flBool __stdcall
operator <=(const flString& str1, const flString& str2)
{
	return str1 <= str2._string;
}
//----------------------------------------------------------------------------
inline flBool __stdcall
operator >=(const flChar* str1, const flString& str2)
{
	return str2 < str1;
}
//----------------------------------------------------------------------------
inline flBool __stdcall
operator >=(const flString& str1, const flString& str2)
{
	return str1 >= str2._string;
}
//----------------------------------------------------------------------------
#endif	// !__flString_inl__
