/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "Stdafx.h"
#include <flBase/flSystemTime.h>
#include <sys/timeb.h>
#include <time.h>
//------------------------------------------------------------------------------
flInt64				flSystemTime::_startTime = 0;
flBool				flSystemTime::_performanceCounter = false;
flDouble			flSystemTime::_frequency = 0.0;
flCriticalSection	flSystemTime::_csection;
//------------------------------------------------------------------------------
flSystemTime::flSystemTime() :
flAbsoluteTime()
{
	_csection.enter();
	if (_frequency == 0.0)
	{
		_timeb tb;
		_ftime(&tb);
		_startTime = (flInt64)tb.time * 10000000 + tb.millitm * 10000;

		LARGE_INTEGER hz;
		QueryPerformanceFrequency(&hz);
		_frequency = flDouble(hz.QuadPart);

		if (_frequency == 0.0)
		{
			_frequency = 1000.0;
			_performanceCounter = false;
		}
		else
		{
			_performanceCounter = true;
		}

		if (_performanceCounter)
		{
			QueryPerformanceCounter((LARGE_INTEGER*)&_counter);
			_startTime -= flInt64(flDouble(_counter) / _frequency * 10000000.0);
		}
		else
		{
			_startTime -= GetTickCount();
		}
	}
	_csection.leave();

	update();
}
//------------------------------------------------------------------------------
flSystemTime::~flSystemTime()
{
}
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
void
flSystemTime::update()
{
	_csection.enter();

	flInt64 lastTime = _time;

RETRY:
	if (_performanceCounter)
	{
		QueryPerformanceCounter((LARGE_INTEGER*)&_counter);
		_time = flInt64(flDouble(_counter) / _frequency * 10000000.0) + _startTime;
	}
	else
	{
		_time = GetTickCount() + _startTime;
	}

	if (lastTime > _time)
	{
		_timeb tb;
		_ftime(&tb);
		_startTime = (flInt64)tb.time * 10000000 + tb.millitm * 10000;

		if (_performanceCounter)
		{
			QueryPerformanceCounter((LARGE_INTEGER*)&_counter);
			_startTime -= flInt64(flDouble(_counter) / _frequency * 10000000.0);
		}
		else
		{
			_startTime -= GetTickCount();
		}

		goto RETRY;
	}

	_csection.leave();
}
//------------------------------------------------------------------------------
