/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "StdAfx.h"
//#define	_THREADEX
#include <flBase/flThread.h>
#ifdef _THREADEX
#include <process.h>
#endif
//------------------------------------------------------------------------------
flThread::flThread() :
flThreadHandle()
{
}
//------------------------------------------------------------------------------
flThread::flThread(HANDLE handle) :
flThreadHandle(handle)
{
}
//------------------------------------------------------------------------------
flThread::flThread(ThreadProc proc, void* data, flBool createSuspended) :
flThreadHandle()
{
	create(proc, data, createSuspended);
}
//------------------------------------------------------------------------------
flThread::~flThread()
{
	if (isValid())
	{
		const flUInt msec = 1000;
		if (!waitFor(msec))
			terminate();
	}
}
//------------------------------------------------------------------------------
flBool
flThread::create(ThreadProc proc, void* data, flBool createSuspended)
{
	if (isValid())
		return false;

#ifdef _THREADEX
	_handle = (HANDLE)_beginthreadex(
					NULL,
					0,
					proc,
					data,
					createSuspended ? CREATE_SUSPENDED : 0,
					&_threadID);
#else
	_handle = CreateThread(
					NULL,
					0,
					(LPTHREAD_START_ROUTINE)proc,
					data,
					createSuspended ? CREATE_SUSPENDED : 0,
					(flULong*)&_threadID);
#endif

	return isValid();
}
//------------------------------------------------------------------------------
flBool
flThread::suspend() const
{
	assert(_handle != INVALID_HANDLE_VALUE);

	return SuspendThread(_handle) != (DWORD)-1;
}
//------------------------------------------------------------------------------
flBool
flThread::resume() const
{
	assert(_handle != INVALID_HANDLE_VALUE);

	return ResumeThread(_handle) != (DWORD)-1;
}
//------------------------------------------------------------------------------
void
flThread::exit(flUInt exitCode) const
{
#ifdef _THREADEX
	_endthreadex(exitCode);
#else
	ExitThread(exitCode);
#endif
}
//------------------------------------------------------------------------------
flBool
flThread::terminate(flUInt exitCode) const
{
	assert(_handle != INVALID_HANDLE_VALUE);

	return TerminateThread(_handle, exitCode) != 0;
}
//------------------------------------------------------------------------------
flBool
flThread::getExitCode(flUInt& exitCode) const
{
	assert(_handle != INVALID_HANDLE_VALUE);

	return GetExitCodeThread(_handle, (flULong*)&exitCode) != 0;
}
//------------------------------------------------------------------------------
flBool
flThread::setPriority(PriorityEnum priority) const
{
	assert(_handle != INVALID_HANDLE_VALUE);

	flInt p;

	switch (priority)
	{
	case THREAD_PRIORITY_ABOVE_NORMAL:
		p = THREAD_PRIORITY_ABOVE_NORMAL;
		break;
	case THREAD_PRIORITY_BELOW_NORMAL:
		p = THREAD_PRIORITY_BELOW_NORMAL;
		break;
	case THREAD_PRIORITY_HIGHEST:
		p = THREAD_PRIORITY_HIGHEST;
		break;
	case THREAD_PRIORITY_IDLE:
		p = THREAD_PRIORITY_IDLE;
		break;
	case THREAD_PRIORITY_LOWEST:
		p = THREAD_PRIORITY_LOWEST;
		break;
	case THREAD_PRIORITY_NORMAL:
		p = THREAD_PRIORITY_NORMAL;
		break;

	default:
		return false;
	}

	return SetThreadPriority(_handle, p) != 0;
}
//------------------------------------------------------------------------------
flThread::PriorityEnum
flThread::getPriority() const
{
	assert(_handle != INVALID_HANDLE_VALUE);

	flInt p = GetThreadPriority(_handle);
	switch (p)
	{
	case THREAD_PRIORITY_ABOVE_NORMAL:
		return ABOVE_NORMAL;
	case THREAD_PRIORITY_BELOW_NORMAL:
		return BELOW_NORMAL;
	case THREAD_PRIORITY_HIGHEST:
		return HIGHEST;
	case THREAD_PRIORITY_IDLE:
		return IDLE;
	case THREAD_PRIORITY_LOWEST:
		return LOWEST;
	case THREAD_PRIORITY_NORMAL:
		return NORMAL;
	}

	return UNKNOWN_PRIORITY;
}
//------------------------------------------------------------------------------
flUInt
flThread::getThreadID() const
{
	return _threadID;
}
//------------------------------------------------------------------------------
