/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef	__flThread_h__
#define	__flThread_h__
//------------------------------------------------------------------------------
#include <flBase/flThreadHandle.h>
//------------------------------------------------------------------------------
class flThread : public flThreadHandle
{
public:
	enum PriorityEnum
	{
		UNKNOWN_PRIORITY,

		ABOVE_NORMAL,
		BELOW_NORMAL,
		HIGHEST,
		IDLE,
		LOWEST,
		NORMAL,
		TIME_CRITICAL,

		DEFAULT_PRIORITY = NORMAL
	};

	typedef flUInt	(__stdcall *ThreadProc)(void*);

	flThread();
	flThread(HANDLE handle);
	flThread(ThreadProc proc, void* data, flBool createSuspended = false);
	virtual ~flThread();

public:
	flBool			create(ThreadProc proc, void* data,
						flBool createSuspended = false);

	flBool			suspend() const;
	flBool			resume() const;

	void			exit(flUInt exitCode = 0) const;
	flBool			terminate(flUInt exitCode = 0) const;
	flBool			getExitCode(flUInt& exitCode) const;

	flBool			setPriority(PriorityEnum priority) const;
	PriorityEnum	getPriority() const;

	flUInt			getThreadID() const;

protected:
	flUInt			_threadID;
};
//------------------------------------------------------------------------------
#endif	// !__flThread_h__
