/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "Stdafx.h"
#include <flBase/flTimer.h>
//------------------------------------------------------------------------------
#define MAX_FL_TIMER_COUNT	100
#define TIMER_NAME_PREFIX	"FLTIMER"
//------------------------------------------------------------------------------
flTimer::flTimer()
{
	flChar str[256];

	for(flUInt i = 0; i < MAX_FL_TIMER_COUNT; i++)
	{
		sprintf(str, "%s%d", TIMER_NAME_PREFIX, i);
		HANDLE handle = OpenWaitableTimer(TIMER_ALL_ACCESS, FALSE, str);

		if (!handle)
			break;

		CloseHandle(handle);
	}

	if (i != MAX_FL_TIMER_COUNT)
		_handle = CreateWaitableTimer(NULL, FALSE, str);
	else
		_handle = NULL;
}
//------------------------------------------------------------------------------
flTimer::~flTimer()
{
	if (_handle)
		CloseHandle(_handle);
}
//------------------------------------------------------------------------------
flBool
flTimer::active(LONGLONG dueTime, LONG period)
{
	if (!_handle)
		return false;
	
	_dueTime.QuadPart = dueTime;
	return (SetWaitableTimer(_handle, &_dueTime, period, NULL, NULL, FALSE) == TRUE);
}
//------------------------------------------------------------------------------
flBool
flTimer::deactive()
{
	if (!_handle)
		return false;

	return (CancelWaitableTimer(_handle) == TRUE);
}
//------------------------------------------------------------------------------
