/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __DigitalClock_h__
#define __DigitalClock_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif

#include <flFilterCommon/flSource.h>
#include <flTypes/flUIDs.h>
#include <flTypes/IDigitalClock.h>
#include <flBase/flImage.h>
#include <flBase/flImageIO.h>
#include <flBase/flString.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class flTextDraw;
class flFillColor;
class CDigitalClockStream;
//------------------------------------------------------------------------------
class CDigitalClock :
		public CFLSource,
		public CPersistStream, 
		public ISpecifyPropertyPages,
		public IDigitalClock
{
	friend class CDigitalClockStream;

public:
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN punk, HRESULT *phr);

    DECLARE_IUNKNOWN;

private:
    CDigitalClock(TCHAR *tszName, LPUNKNOWN pUnk, HRESULT *phr);
    ~CDigitalClock();

public:
	// Reveals IDigitalClock & ISpecifyPropertyPages
    STDMETHODIMP	NonDelegatingQueryInterface(REFIID riid, void ** ppv);

public:
	// IMediaFilter
	STDMETHODIMP	Run(REFERENCE_TIME startTime);
	STDMETHODIMP	Pause();
	STDMETHODIMP	Stop();
	STDMETHODIMP	GetState(DWORD dwMSecs, FILTER_STATE *State);

	// IPersistStream
    STDMETHODIMP	GetClassID(CLSID *pClsid);
	HRESULT			WriteToStream(IStream *pStream);
    HRESULT			ReadFromStream(IStream *pStream);
	DWORD			GetSoftwareVersion(void);
	int				SizeMax();

    // ISpecifyPropertyPages method
    STDMETHODIMP	GetPages(CAUUID *pPages);

	// IDigitalClock
	STDMETHODIMP	get_OutputVideoResolution(flInt *videoResolution);
	STDMETHODIMP	put_OutputVideoResolution(flInt videoResolution);
	STDMETHODIMP	get_FrameRate(flInt *frameRate);
	STDMETHODIMP	put_FrameRate(flInt frameRate);
	STDMETHODIMP	get_FontSize(flInt* fontSize);
	STDMETHODIMP	put_FontSize(flInt fontSize);
	STDMETHODIMP	get_FontColor(flByte *color);
	STDMETHODIMP	put_FontColor(const flByte *color);
	STDMETHODIMP	get_BackgroundColor(flByte *color);
	STDMETHODIMP	put_BackgroundColor(const flByte *color);
	STDMETHODIMP	get_HeaderString(flChar *string);
	STDMETHODIMP	put_HeaderString(const flChar *string);
	STDMETHODIMP	get_FooterString(flChar *string);
	STDMETHODIMP	put_FooterString(const flChar *string);

private:
	void			setup();
	void			draw(flByte* data, flUInt dataLength);

protected:
	// Ciritcal Section for filter
	CCritSec				_filterLock;

	// Property
	flInt					_outVideoResolution;
	flInt					_frameRate;
	flInt					_fontSize;
	flByte					_fontColor[3];
	flByte					_backgroundColor[3];
	flString				_headerString;
	flString				_footerString;

	// Status
	flBool					_isRunning;

	// Shape Draws
	flTextDraw*				_time1TextDraw;
	flTextDraw*				_time2TextDraw;
	flTextDraw*				_headerTextDraw;
	flTextDraw*				_footerTextDraw;
	flFillColor*			_backgroundDraw;

protected:
	// Output Stream pin
	CDigitalClockStream*	_digitalClockStream;
};
//------------------------------------------------------------------------------
#endif //__DigitalClock_h__
