/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include <windows.h>
#define WIN32_LEAN_AND_MEAN
#include <streams.h>

#include <flDigitalClock/DigitalClockProp.h>
#include <commctrl.h>
#include <tchar.h>
#include "resource.h"
//------------------------------------------------------------------------------
CUnknown * WINAPI
CDigitalClockProp::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
	CUnknown *punk = new CDigitalClockProp(lpunk, phr);
	if (punk == NULL)
	{
		*phr = E_OUTOFMEMORY;
	}
	return punk;
}
//------------------------------------------------------------------------------
CDigitalClockProp::CDigitalClockProp(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("DigitalClockProp"),pUnk,
                      IDD_DIGITALCLOCKPROP,
                      IDS_DIGITALCLOCKPROPTITLE),
    _digitalClock(NULL)
{
	InitCommonControls();
}
//------------------------------------------------------------------------------
void
CDigitalClockProp::SetDirty()
{
	m_bDirty = TRUE;
	if (m_pPageSite)
	{
		m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
	}
}
//------------------------------------------------------------------------------
BOOL
CDigitalClockProp::OnReceiveMessage(HWND hwnd,
									UINT uMsg,
									WPARAM wParam,
									LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			setupControls();
			return (LRESULT) 1;
        }
        case WM_COMMAND:
        {
			switch(LOWORD(wParam))
			{
			case IDC_OUTPUTRESOLUTION_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					_outVideoResolution = 
							ComboBox_GetCurSel(GetDlgItem(m_Dlg, IDC_OUTPUTRESOLUTION_COMBO));
					SetDirty();
				}
				break;
			case IDC_FRAMERATE_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_FRAMERATE_EDIT),
													sz, STR_MAX_LENGTH);
					_frameRate = (flInt)atof(sz);
					SetDirty();
				}
				break;
			case IDC_FONTSIZE_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					_fontSize = ComboBox_GetCurSel(GetDlgItem(m_Dlg, IDC_FONTSIZE_COMBO));
					SetDirty();
				}
				break;
			case IDC_FONTCOLORR_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_FONTCOLORR_EDIT), sz, STR_MAX_LENGTH);
					_fontColor[0] = (flInt)atoi(sz);
					SetDirty();
				}
				break;
			case IDC_FONTCOLORG_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_FONTCOLORG_EDIT), sz, STR_MAX_LENGTH);
					_fontColor[1] = (flInt)atoi(sz);
					SetDirty();
				}
				break;
			case IDC_FONTCOLORB_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_FONTCOLORB_EDIT), sz, STR_MAX_LENGTH);
					_fontColor[2] = (flInt)atoi(sz);
					SetDirty();
				}
				break;
			case IDC_BGCOLORR_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_BGCOLORR_EDIT), sz, STR_MAX_LENGTH);
					_backgroundColor[0] = (flInt)atoi(sz);
					SetDirty();
				}
				break;
			case IDC_BGCOLORG_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_BGCOLORG_EDIT), sz, STR_MAX_LENGTH);
					_backgroundColor[1] = (flInt)atoi(sz);
					SetDirty();
				}
				break;
			case IDC_BGCOLORB_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_BGCOLORB_EDIT), sz, STR_MAX_LENGTH);
					_backgroundColor[2] = (flInt)atoi(sz);
					SetDirty();
				}
				break;
			case IDC_HEADER_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[DC_MAXIMUM_HEADERFOOTER_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_HEADER_EDIT), sz, DC_MAXIMUM_HEADERFOOTER_LENGTH);
					_headerString = flString(sz);
					SetDirty();
				}
				break;
			case IDC_FOOTER_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[DC_MAXIMUM_HEADERFOOTER_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_FOOTER_EDIT), sz, DC_MAXIMUM_HEADERFOOTER_LENGTH);
					_footerString = flString(sz);
					SetDirty();
				}
				break;
			case IDC_FONTCOLORREF_BUTTON:
				{
					COLORREF color;
					COLORREF custColors[16];

					color = RGB(_fontColor[0], _fontColor[1], _fontColor[2]);

					CHOOSECOLOR cc;
					memset(&cc, 0, sizeof(CHOOSECOLOR));
					cc.lStructSize	= sizeof(CHOOSECOLOR);
					cc.hwndOwner	= NULL;
					cc.rgbResult	= color;
					cc.lpCustColors	= custColors;
					cc.Flags	= CC_FULLOPEN | CC_RGBINIT;
					if (ChooseColor(&cc) == TRUE)
					{
						TCHAR sz[STR_MAX_LENGTH];

						_stprintf(sz, TEXT("%d"), GetRValue(cc.rgbResult));
						Edit_SetText(GetDlgItem(m_Dlg, IDC_FONTCOLORR_EDIT), sz);

						_stprintf(sz, TEXT("%d"), GetGValue(cc.rgbResult));
						Edit_SetText(GetDlgItem(m_Dlg, IDC_FONTCOLORG_EDIT), sz);

						_stprintf(sz, TEXT("%d"), GetBValue(cc.rgbResult));
						Edit_SetText(GetDlgItem(m_Dlg, IDC_FONTCOLORB_EDIT), sz);
					}
				}
				break;
			case IDC_BGCOLORREF_BUTTON:
				{
					COLORREF color;
					COLORREF custColors[16];

					color = RGB(_backgroundColor[0], _backgroundColor[1], _backgroundColor[2]);

					CHOOSECOLOR cc;
					memset(&cc, 0, sizeof(CHOOSECOLOR));
					cc.lStructSize	= sizeof(CHOOSECOLOR);
					cc.hwndOwner	= NULL;
					cc.rgbResult	= color;
					cc.lpCustColors	= custColors;
					cc.Flags	= CC_FULLOPEN | CC_RGBINIT;
					if (ChooseColor(&cc) == TRUE)
					{
						TCHAR sz[STR_MAX_LENGTH];

						_stprintf(sz, TEXT("%d"), GetRValue(cc.rgbResult));
						Edit_SetText(GetDlgItem(m_Dlg, IDC_BGCOLORR_EDIT), sz);

						_stprintf(sz, TEXT("%d"), GetGValue(cc.rgbResult));
						Edit_SetText(GetDlgItem(m_Dlg, IDC_BGCOLORG_EDIT), sz);

						_stprintf(sz, TEXT("%d"), GetBValue(cc.rgbResult));
						Edit_SetText(GetDlgItem(m_Dlg, IDC_BGCOLORB_EDIT), sz);
					}
				}
				break;
			}
			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
			shutdownControls();
            return (LRESULT) 1;
        }

    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);
}
//------------------------------------------------------------------------------
HRESULT
CDigitalClockProp::OnConnect(IUnknown *pUnknown)
{
    ASSERT(_digitalClock == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IDigitalClock, (void **) &_digitalClock);
    if (FAILED(hr))
	{
        return E_NOINTERFACE;
    }

    ASSERT(_digitalClock);

	flChar str[DC_MAXIMUM_HEADERFOOTER_LENGTH];

	_digitalClock->get_OutputVideoResolution(&_outVideoResolution);
	_digitalClock->get_FrameRate(&_frameRate);
	_digitalClock->get_FontSize(&_fontSize);
	_digitalClock->get_FontColor(_fontColor);
	_digitalClock->get_BackgroundColor(_backgroundColor);
	_digitalClock->get_HeaderString(str);
	_headerString = flString(str);
	_digitalClock->get_FooterString(str);
	_footerString = flString(str);

    return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CDigitalClockProp::OnDisconnect()
{
    if (_digitalClock == NULL)
	{
        return E_UNEXPECTED;
    }

    _digitalClock->Release();
    _digitalClock = NULL;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CDigitalClockProp::OnDeactivate(void)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CDigitalClockProp::OnApplyChanges()
{
	_digitalClock->put_OutputVideoResolution(_outVideoResolution);
	_digitalClock->put_FrameRate(_frameRate);
	_digitalClock->put_FontSize(_fontSize);
	_digitalClock->put_FontColor(_fontColor);
	_digitalClock->put_BackgroundColor(_backgroundColor);
	_digitalClock->put_HeaderString(_headerString.length() == 0 ? "" : _headerString.c_str());
	_digitalClock->put_FooterString(_footerString.length() == 0 ? "" : _footerString.c_str());

	m_bDirty = FALSE;
	return NOERROR;
}
//------------------------------------------------------------------------------
void
CDigitalClockProp::setupControls()
{
	TCHAR   sz[32];

	// Video Resolution
	HWND item = GetDlgItem(m_Dlg, IDC_OUTPUTRESOLUTION_COMBO);
	ComboBox_ResetContent(item);
	ComboBox_AddString(item, _T("SQCIF"));
	ComboBox_AddString(item, _T("QCIF"));
	ComboBox_AddString(item, _T("CIF"));
	ComboBox_AddString(item, _T("160x120"));
	ComboBox_AddString(item, _T("320x240"));
	ComboBox_AddString(item, _T("360x240"));
	ComboBox_AddString(item, _T("640x480"));
	ComboBox_AddString(item, _T("720x480"));
	ComboBox_AddString(item, _T("800x600"));
	ComboBox_AddString(item, _T("1024x768"));
	ComboBox_AddString(item, _T("1280x1024"));
	ComboBox_AddString(item, _T("1600x1200"));
	ComboBox_AddString(item, _T("HDTV 720p"));
	ComboBox_AddString(item, _T("HDTV 1080i"));
	ComboBox_AddString(item, _T("SDTV 480p"));
	ComboBox_AddString(item, _T("SDTV 480i"));
	ComboBox_SetCurSel(item, _outVideoResolution);

	// Frame Rate
	_stprintf(sz, "%d", _frameRate);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAMERATE_EDIT), sz);

	// Font Size
	item = GetDlgItem(m_Dlg, IDC_FONTSIZE_COMBO);
	ComboBox_ResetContent(item);
	ComboBox_AddString(item, _T("8 pt."));
	ComboBox_AddString(item, _T("12 pt."));
	ComboBox_AddString(item, _T("16 pt."));
	ComboBox_AddString(item, _T("20 pt."));
	ComboBox_AddString(item, _T("24 pt."));
	ComboBox_AddString(item, _T("28 pt."));
	ComboBox_AddString(item, _T("36 pt."));
	ComboBox_AddString(item, _T("44 pt."));
	ComboBox_AddString(item, _T("60 pt."));
	ComboBox_AddString(item, _T("76 pt."));
	ComboBox_AddString(item, _T("100 pt."));
	ComboBox_AddString(item, _T("124 pt."));
	ComboBox_AddString(item, _T(""));
	ComboBox_SetCurSel(item, _fontSize);

	// Font Color
	_stprintf(sz, "%d", _fontColor[0]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_FONTCOLORR_EDIT), sz);
	_stprintf(sz, "%d", _fontColor[1]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_FONTCOLORG_EDIT), sz);
	_stprintf(sz, "%d", _fontColor[2]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_FONTCOLORB_EDIT), sz);

	// Background Color
	_stprintf(sz, "%d", _backgroundColor[0]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_BGCOLORR_EDIT), sz);
	_stprintf(sz, "%d", _backgroundColor[1]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_BGCOLORG_EDIT), sz);
	_stprintf(sz, "%d", _backgroundColor[2]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_BGCOLORB_EDIT), sz);

	// Header String
	_stprintf(sz, "%s", _headerString.length() == 0 ? "" : _headerString.c_str());
	Edit_SetText(GetDlgItem(m_Dlg, IDC_HEADER_EDIT), sz);

	// Footer String
	_stprintf(sz, "%s", _footerString.length() == 0 ? "" : _footerString.c_str());
	Edit_SetText(GetDlgItem(m_Dlg, IDC_FOOTER_EDIT), sz);
}
//------------------------------------------------------------------------------
void
CDigitalClockProp::shutdownControls()
{
}
//------------------------------------------------------------------------------
