/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __DigitalClockProp_h__
#define __DigitalClockProp_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif
#include <flTypes/flUIDs.h>
#include <flTypes/IDigitalClock.h>
#include <flBase/flString.h>
//------------------------------------------------------------------------------
class CDigitalClockProp : public CBasePropertyPage
{
public:
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN lpunk, HRESULT *phr);

private:
    CDigitalClockProp(LPUNKNOWN lpunk, HRESULT *phr);

private:
    void		SetDirty();

    BOOL		OnReceiveMessage(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
    HRESULT		OnConnect(IUnknown *pUnknown);
    HRESULT		OnDisconnect();
    HRESULT		OnDeactivate();
    HRESULT		OnApplyChanges();

private:
	void		setupControls();
	void		shutdownControls();

private:
    IDigitalClock*	_digitalClock;

private:
	// Property
	flInt			_outVideoResolution;
	flInt			_frameRate;
	flInt			_fontSize;
	flByte			_fontColor[3];
	flByte			_backgroundColor[3];
	flString		_headerString;
	flString		_footerString;
};
//------------------------------------------------------------------------------
#endif //__DigitalClockProp_h__
