/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __DigitalClockStream_h__
#define __DigitalClockStream_h__
//------------------------------------------------------------------------------
#include <flFilterCommon/flSourceStream.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CDigitalClock;
//------------------------------------------------------------------------------
class CDigitalClockStream : public CFLSourceStream
{

public:
    CDigitalClockStream(HRESULT *phr, CDigitalClock *pParent, LPCWSTR pPinName);
    ~CDigitalClockStream();

public:
    HRESULT			FillBuffer(IMediaSample *pms);
	void			AdjustRate(flInt64 deliverProcTime);

    HRESULT			DecideBufferSize(IMemAllocator *pIMemAlloc,
                             ALLOCATOR_PROPERTIES *pProperties);

    HRESULT			SetMediaType(const CMediaType *pmt);
	HRESULT			GetMediaType(CMediaType *pmt);

	HRESULT			OnThreadCreate();

    STDMETHODIMP	Notify(IBaseFilter * pSender, Quality q);

protected:
	CDigitalClock*	_digitalClock;
	REFERENCE_TIME	_streamTime;
};
//------------------------------------------------------------------------------
#endif //__DigitalClockStream_h__
