/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "StdAfx.h"
#include <flDirectInput/flDirectInputDevice.h>
//------------------------------------------------------------------------------
flDirectInputDevice::flDirectInputDevice(LPDIRECTINPUTDEVICE8 device) :
_device(device),
_isValid(false),
_isForeground(false),
_isExclusive(false)
{
	setForeground(false, NULL);
	setExclusive(true);
}
//------------------------------------------------------------------------------
flDirectInputDevice::~flDirectInputDevice()
{
	if (_device)
	{
		_device->Release();
		_device = NULL;
	}
}
//------------------------------------------------------------------------------
flBool
flDirectInputDevice::isValid() const
{
	return _isValid;
}
//------------------------------------------------------------------------------
flBool
flDirectInputDevice::isForeground() const
{
	return _isForeground;
}
//------------------------------------------------------------------------------
flBool
flDirectInputDevice::setForeground(flBool flag, HWND hWnd)
{
	if (flag && hWnd == NULL)
		return false;

	_isForeground = flag;
	_hWnd = hWnd;

	DWORD coorp;
	coorp = (_isForeground ? DISCL_FOREGROUND : DISCL_BACKGROUND);
	coorp |= (_isExclusive ? DISCL_EXCLUSIVE : DISCL_NONEXCLUSIVE);

	return SUCCEEDED(_device->SetCooperativeLevel(_hWnd, coorp));
}
//------------------------------------------------------------------------------
flBool
flDirectInputDevice::isExclusive() const
{
	return _isExclusive;
}
//------------------------------------------------------------------------------
flBool
flDirectInputDevice::setExclusive(flBool flag)
{
	assert(!(_isForeground && _hWnd == NULL));

	_isExclusive = flag;

	DWORD coorp;
	coorp = (_isForeground ? DISCL_FOREGROUND : DISCL_BACKGROUND);
	coorp |= (_isExclusive ? DISCL_EXCLUSIVE : DISCL_NONEXCLUSIVE);

	return SUCCEEDED(_device->SetCooperativeLevel(_hWnd, coorp));
}
//------------------------------------------------------------------------------

