/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flDirectInputDevice_h__
#define __flDirectInputDevice_h__
//------------------------------------------------------------------------------
#include <flDirectInput/flDirectInput.h>
#include <flBase/flArray.h>
//------------------------------------------------------------------------------
class flDirectInputDevice;
typedef flArray<flDirectInputDevice*>	flDirectInputDevicePtrArray;
//------------------------------------------------------------------------------
class flDirectInputDevice
{
protected:
	flDirectInputDevice(LPDIRECTINPUTDEVICE8 device);

public:
	virtual ~flDirectInputDevice();

public:
	flBool			isValid() const;

public:
	virtual void	update() = 0;

public:
	flBool			isForeground() const;
	flBool			setForeground(flBool flag, HWND hWnd = NULL);

	flBool			isExclusive() const;
	flBool			setExclusive(flBool flag);

protected:
	LPDIRECTINPUTDEVICE8	_device;
	flBool					_isValid;

	flBool					_isForeground;
	flBool					_isExclusive;
	HWND					_hWnd;
};
//------------------------------------------------------------------------------
#endif	// !__flDirectInputDevice_h__
