/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "StdAfx.h"
#include <flDirectInput/flGameController.h>
#include <flBase/flNotify.h>
//------------------------------------------------------------------------------
flGameController::flGameController(LPDIRECTINPUTDEVICE8 device) :
flDirectInputDevice(device),
_isValidXAxis(false),
_isValidYAxis(false),
_isValidZAxis(false),
_isValidRxAxis(false),
_isValidRyAxis(false),
_isValidRzAxis(false),
_numSlider(0),
_numPOV(0),
_numButton(0),
_xAxis(0),
_yAxis(0),
_zAxis(0),
_rxAxis(0),
_ryAxis(0),
_rzAxis(0)
{
	for(flUInt i = 0; i < MAX_SLIDER; i++)
		_slider[i] = 0;
	for(flUInt i = 0; i < MAX_POV; i++)
		_pov[i] = 0;
	for(flUInt i = 0; i < MAX_JBUTTON; i++)
		_button[i] = false;

	if (SUCCEEDED(device->SetDataFormat(&c_dfDIJoystick2)))
	{
		if (SUCCEEDED(device->EnumObjects(enumObjectsCallback, this, DIDFT_ALL)))
		{
			_isValid = true;

			device->Acquire();
		}
	}
}
//------------------------------------------------------------------------------
flGameController::~flGameController()
{
}
//------------------------------------------------------------------------------
void
flGameController::update()
{
	HRESULT     hr;
	DIJOYSTATE2 js;

	hr = _device->Poll(); 

	if (FAILED(hr))  
	{
		hr = _device->Acquire();
		while(hr == DIERR_INPUTLOST) 
			hr = _device->Acquire();

		return ; 
	}

	if (FAILED(hr = _device->GetDeviceState(sizeof(DIJOYSTATE2), &js)))
		return ;

	_xAxis = js.lX;
	_yAxis = js.lY;
	_zAxis = js.lZ;
	_rxAxis = js.lRx;
	_ryAxis = js.lRy;
	_rzAxis = js.lRz;

	for(flUInt i = 0; i < MAX_SLIDER; i++)
		_slider[i] = js.rglSlider[i];

	for(flUInt i = 0; i < MAX_POV; i++)
		_pov[i] = (flInt)js.rgdwPOV[i];

	for(flUInt i = 0; i < MAX_JBUTTON; i++)
		_button[i] = (js.rgbButtons[i] & 0x80) != 0;
}
//------------------------------------------------------------------------------
flBool
flGameController::isValidXAxis() const
{
	return _isValidXAxis;
}
//------------------------------------------------------------------------------
flBool
flGameController::isValidYAxis() const
{
	return _isValidYAxis;
}
//------------------------------------------------------------------------------
flBool
flGameController::isValidZAxis() const
{
	return _isValidZAxis;
}
//------------------------------------------------------------------------------
flBool
flGameController::isValidRxAxis() const
{
	return _isValidRxAxis;
}
//------------------------------------------------------------------------------
flBool
flGameController::isValidRyAxis() const
{
	return _isValidRyAxis;
}
//------------------------------------------------------------------------------
flBool
flGameController::isValidRzAxis() const
{
	return _isValidRzAxis;
}
//------------------------------------------------------------------------------
flUInt
flGameController::getNumSlider() const
{
	return _numSlider;
}
//------------------------------------------------------------------------------
flUInt
flGameController::getNumPOV() const
{
	return _numPOV;
}
//------------------------------------------------------------------------------
flUInt
flGameController::getNumButton() const
{
	return _numButton;
}
//------------------------------------------------------------------------------
flLong
flGameController::getXAxis() const
{
	return _xAxis;
}
//------------------------------------------------------------------------------
flLong
flGameController::getYAxis() const
{
	return _yAxis;
}
//------------------------------------------------------------------------------
flLong
flGameController::getZAxis() const
{
	return _zAxis;
}
//------------------------------------------------------------------------------
flLong
flGameController::getRxAxis() const
{
	return _rxAxis;
}
//------------------------------------------------------------------------------
flLong
flGameController::getRyAxis() const
{
	return _ryAxis;
}
//------------------------------------------------------------------------------
flLong
flGameController::getRzAxis() const
{
	return _rzAxis;
}
//------------------------------------------------------------------------------
flLong
flGameController::getSlider(flUInt index) const
{
	if (index >= MAX_SLIDER)
		return 0;
	return _slider[index];
}
//------------------------------------------------------------------------------
flInt
flGameController::getPOV(flUInt index) const
{
	if (index >= MAX_POV)
		return 0;
	return _pov[index];
}
//------------------------------------------------------------------------------
flBool
flGameController::getButton(flUInt index) const
{
	if (index >= MAX_JBUTTON)
		return 0;
	return _button[index];
}
//------------------------------------------------------------------------------
BOOL
flGameController::enumObject(const DIDEVICEOBJECTINSTANCE* pdidoi)
{

    if (pdidoi->dwType & DIDFT_AXIS)
    {
        DIPROPRANGE diprg; 
        diprg.diph.dwSize       = sizeof(DIPROPRANGE); 
        diprg.diph.dwHeaderSize = sizeof(DIPROPHEADER); 
        diprg.diph.dwHow        = DIPH_BYID; 
        diprg.diph.dwObj        = pdidoi->dwType;
        diprg.lMin              = -1000; 
        diprg.lMax              = +1000; 
    
        if( FAILED( _device->SetProperty( DIPROP_RANGE, &diprg.diph ) ) ) 
            return DIENUM_STOP;
    }

	if (pdidoi->dwType & DIDFT_BUTTON && _numButton < MAX_JBUTTON)
	{
		_numButton++;
	}

    if (pdidoi->guidType == GUID_XAxis)
		_isValidXAxis = true;

	if (pdidoi->guidType == GUID_YAxis)
		_isValidYAxis = true;

	if (pdidoi->guidType == GUID_ZAxis)
		_isValidZAxis = true;

	if (pdidoi->guidType == GUID_RxAxis)
		_isValidRxAxis = true;

	if (pdidoi->guidType == GUID_RyAxis)
		_isValidRyAxis = true;

	if (pdidoi->guidType == GUID_RzAxis)
		_isValidRzAxis = true;

	if (pdidoi->guidType == GUID_Slider && _numSlider < MAX_SLIDER)
		_numSlider++;

	if (pdidoi->guidType == GUID_POV && _numPOV < MAX_POV)
		_numPOV++;


    return DIENUM_CONTINUE;
}
//------------------------------------------------------------------------------
BOOL CALLBACK __stdcall
flGameController::enumObjectsCallback(const DIDEVICEOBJECTINSTANCE* pdidoi, VOID* pContext )
{
	flGameController* instance = (flGameController *)pContext;
	return instance->enumObject(pdidoi);
}
//------------------------------------------------------------------------------
