/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flGameController_h__
#define __flGameController_h__
//------------------------------------------------------------------------------
#include <flDirectInput/flDirectInputDevice.h>
//------------------------------------------------------------------------------
#define MAX_SLIDER	2
#define MAX_POV		4
#define MAX_JBUTTON	256
//------------------------------------------------------------------------------
class flGameController;
//------------------------------------------------------------------------------
class flGameController : public flDirectInputDevice
{
	friend class flGameControllerEnumerator;

protected:
	flGameController(LPDIRECTINPUTDEVICE8 device);

public:
	virtual ~flGameController();

public:
	virtual void	update();

public:
	flBool			isValidXAxis() const;
	flBool			isValidYAxis() const;
	flBool			isValidZAxis() const;
	flBool			isValidRxAxis() const;
	flBool			isValidRyAxis() const;
	flBool			isValidRzAxis() const;
	flUInt			getNumSlider() const;
	flUInt			getNumPOV() const;
	flUInt			getNumButton() const;

	flLong			getXAxis() const;
	flLong			getYAxis() const;
	flLong			getZAxis() const;
	flLong			getRxAxis() const;
	flLong			getRyAxis() const;
	flLong			getRzAxis() const;
	flLong			getSlider(flUInt index) const;
	flInt			getPOV(flUInt index) const;
	flBool			getButton(flUInt index) const;

private:
	BOOL			enumObject(const DIDEVICEOBJECTINSTANCE* pdidoi);
	static BOOL CALLBACK __stdcall	enumObjectsCallback(
						const DIDEVICEOBJECTINSTANCE* pdidoi, VOID* pContext );

protected:
	flBool			_isValidXAxis;
	flBool			_isValidYAxis;
	flBool			_isValidZAxis;
	flBool			_isValidRxAxis;
	flBool			_isValidRyAxis;
	flBool			_isValidRzAxis;
	flUInt			_numSlider;
    flUInt			_numPOV;
	flUInt			_numButton;

	flLong			_xAxis;
	flLong			_yAxis;
	flLong			_zAxis;
	flLong			_rxAxis;
	flLong			_ryAxis;
	flLong			_rzAxis;
	flLong			_slider[MAX_SLIDER];
	flInt			_pov[MAX_POV];
	flBool			_button[MAX_JBUTTON];
};
//------------------------------------------------------------------------------
#endif	// !__flGameController_h__
