/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "StdAfx.h"
#include <flDirectInput/flGameController.h>
#include <flDirectInput/flGameControllerEnumerator.h>
//------------------------------------------------------------------------------
flGameControllerEnumerator::flGameControllerEnumerator()
: flDirectInputEnumerator()
{
	LPDIRECTINPUT8 diInst = getDIInstance();

	if (diInst)
		diInst->EnumDevices(DI8DEVCLASS_GAMECTRL, enumJoysticksCallback, this, DIEDFL_ATTACHEDONLY);

}
//------------------------------------------------------------------------------
flGameControllerEnumerator::~flGameControllerEnumerator()
{
	for(flUInt i = 0; i < _devices.getSize(); i++)
		delete _devices[i];
}
//------------------------------------------------------------------------------
BOOL
flGameControllerEnumerator::enumJoystick(const DIDEVICEINSTANCE* pdidInstance)
{
    HRESULT hr;

	LPDIRECTINPUT8 diInst = getDIInstance();
	LPDIRECTINPUTDEVICE8 device;

    hr = diInst->CreateDevice( pdidInstance->guidInstance, &device, NULL );

	if (SUCCEEDED(hr))
	{
		flDirectInputDevice* directInputDevice = new flGameController(device);
		_devices.add(directInputDevice);
	}

    return DIENUM_CONTINUE;
}
//------------------------------------------------------------------------------
BOOL CALLBACK __stdcall
flGameControllerEnumerator::enumJoysticksCallback(const DIDEVICEINSTANCE* pdidInstance, VOID* pContext)
{
	flGameControllerEnumerator* instance = (flGameControllerEnumerator *)pContext;
	return instance->enumJoystick(pdidInstance);
}
//------------------------------------------------------------------------------


