/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "StdAfx.h"
#include <flDirectInput/flMouse.h>
#include <flBase/flNotify.h>
//------------------------------------------------------------------------------
flMouse::flMouse(LPDIRECTINPUTDEVICE8 device) :
flDirectInputDevice(device),
_isValidX(false),
_isValidY(false),
_isValidZ(false),
_numButton(0),
_x(0),
_y(0),
_z(0)
{
	for(flUInt i = 0; i < MAX_MBUTTON; i++)
		_button[i] = false;

	if (SUCCEEDED(device->SetDataFormat(&c_dfDIMouse2)))
	{
		if (SUCCEEDED(device->EnumObjects(enumObjectsCallback, this, DIDFT_ALL)))
		{
			_isValid = true;

			device->Acquire();
		}
	}
}
//------------------------------------------------------------------------------
flMouse::~flMouse()
{
}
//------------------------------------------------------------------------------
void
flMouse::update()
{
	HRESULT     hr;
	DIMOUSESTATE2 ms;

    ZeroMemory(&ms, sizeof(ms));
	hr = _device->GetDeviceState(sizeof(DIMOUSESTATE2), &ms);

	if (FAILED(hr))
	{
		hr = _device->Acquire();
		while(hr == DIERR_INPUTLOST) 
			hr = _device->Acquire();

		return ;
	}

	_x = ms.lX;
	_y = ms.lY;
	_z = ms.lZ;

	for(flUInt i = 0; i < MAX_MBUTTON; i++)
		_button[i] = (ms.rgbButtons[i] & 0x80) != 0;
}
//------------------------------------------------------------------------------
flBool
flMouse::isValidX() const
{
	return _isValidX;
}
//------------------------------------------------------------------------------
flBool
flMouse::isValidY() const
{
	return _isValidY;
}
//------------------------------------------------------------------------------
flBool
flMouse::isValidZ() const
{
	return _isValidZ;
}
//------------------------------------------------------------------------------
flUInt
flMouse::getNumButton() const
{
	return _numButton;
}
//------------------------------------------------------------------------------
flLong
flMouse::getX() const
{
	return _x;
}
//------------------------------------------------------------------------------
flLong
flMouse::getY() const
{
	return _y;
}
//------------------------------------------------------------------------------
flLong
flMouse::getZ() const
{
	return _z;
}
//------------------------------------------------------------------------------
flBool
flMouse::getButton(flUInt index) const
{
	if (index >= MAX_MBUTTON)
		return 0;
	return _button[index];
}
//------------------------------------------------------------------------------
flUShort
flMouse::getButtons() const
{
	flUShort buttons = 0;
	for(flUInt i = 0; i < MAX_MBUTTON; i++)
		buttons |= (_button[i] ? (1 << i) : 0);
	return buttons;
}
//------------------------------------------------------------------------------
BOOL
flMouse::enumObject(const DIDEVICEOBJECTINSTANCE* pdidoi)
{
	if (pdidoi->dwType & DIDFT_BUTTON && _numButton < MAX_MBUTTON)
		_numButton++;

    if (pdidoi->guidType == GUID_XAxis)
		_isValidX = true;

	if (pdidoi->guidType == GUID_YAxis)
		_isValidY = true;

	if (pdidoi->guidType == GUID_ZAxis)
		_isValidZ = true;

    return DIENUM_CONTINUE;
}
//------------------------------------------------------------------------------
BOOL CALLBACK __stdcall
flMouse::enumObjectsCallback(const DIDEVICEOBJECTINSTANCE* pdidoi, VOID* pContext)
{
	flMouse* instance = (flMouse *)pContext;
	return instance->enumObject(pdidoi);
}
//------------------------------------------------------------------------------
