/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flMouse_h__
#define __flMouse_h__
//------------------------------------------------------------------------------
#include <flDirectInput/flDirectInputDevice.h>
//------------------------------------------------------------------------------
#define MAX_MBUTTON	8
//------------------------------------------------------------------------------
class flMouse;
//------------------------------------------------------------------------------
class flMouse : public flDirectInputDevice
{
	friend class flMouseEnumerator;

protected:
	flMouse(LPDIRECTINPUTDEVICE8 device);

public:
	virtual ~flMouse();

public:
	virtual void	update();

public:
	flBool			isValidX() const;
	flBool			isValidY() const;
	flBool			isValidZ() const;
	flUInt			getNumButton() const;

	flLong			getX() const;
	flLong			getY() const;
	flLong			getZ() const;
	flBool			getButton(flUInt index) const;
	flUShort		getButtons() const;

private:
	BOOL			enumObject(const DIDEVICEOBJECTINSTANCE* pdidoi);
	static BOOL CALLBACK __stdcall	enumObjectsCallback(
						const DIDEVICEOBJECTINSTANCE* pdidoi, VOID* pContext );

protected:
	flBool			_isValidX;
	flBool			_isValidY;
	flBool			_isValidZ;
	flUInt			_numButton;

	flLong			_x;
	flLong			_y;
	flLong			_z;
	flBool			_button[MAX_MBUTTON];
};
//------------------------------------------------------------------------------
#endif	// !__flMouse_h__
