/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "StdAfx.h"
#include <flDirectInput/flMouse.h>
#include <flDirectInput/flMouseEnumerator.h>
//------------------------------------------------------------------------------
flMouseEnumerator::flMouseEnumerator()
: flDirectInputEnumerator()
{
	LPDIRECTINPUT8 diInst = getDIInstance();

	if (diInst)
		diInst->EnumDevices(DI8DEVCLASS_POINTER, enumMouseCallback, this, DIEDFL_ATTACHEDONLY);

}
//------------------------------------------------------------------------------
flMouseEnumerator::~flMouseEnumerator()
{
	for(flUInt i = 0; i < _devices.getSize(); i++)
		delete _devices[i];
}
//------------------------------------------------------------------------------
BOOL
flMouseEnumerator::enumMouse(const DIDEVICEINSTANCE* pdidInstance)
{
    HRESULT hr;

	LPDIRECTINPUT8 diInst = getDIInstance();
	LPDIRECTINPUTDEVICE8 device;

    hr = diInst->CreateDevice( pdidInstance->guidInstance, &device, NULL );

	if (SUCCEEDED(hr))
	{
		flDirectInputDevice* directInputDevice = new flMouse(device);
		_devices.add(directInputDevice);
	}

    return DIENUM_CONTINUE;
}
//------------------------------------------------------------------------------
BOOL CALLBACK __stdcall
flMouseEnumerator::enumMouseCallback(const DIDEVICEINSTANCE* pdidInstance, VOID* pContext)
{
	flMouseEnumerator* instance = (flMouseEnumerator *)pContext;
	return instance->enumMouse(pdidInstance);
}
//------------------------------------------------------------------------------


