/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __DrawCaption_h__
#define __DrawCaption_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif

#include <flFilterCommon/flTextDraw.h>
#include <flTypes/flUIDs.h>
#include <flTypes/IDrawCaption.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CDrawCaption :
			public CTransInPlaceFilter,
			public CPersistStream, 
			public IDrawCaption,
			public ISpecifyPropertyPages
{
public:
	static CUnknown * WINAPI	CreateInstance(LPUNKNOWN punk, HRESULT *phr);

private:
	CDrawCaption(TCHAR *tszName, LPUNKNOWN punk, HRESULT *phr);
	virtual ~CDrawCaption();

public:
	DECLARE_IUNKNOWN;

public:
	STDMETHODIMP			NonDelegatingQueryInterface(REFIID riid, void ** ppv);

	HRESULT					CheckInputType(const CMediaType* mtIn);
    HRESULT					SetMediaType(PIN_DIRECTION direction, const CMediaType *pmt);

	// IPersistStream
    STDMETHODIMP			GetClassID(CLSID *pClsid);
	HRESULT					WriteToStream(IStream *pStream);
    HRESULT					ReadFromStream(IStream *pStream);
	DWORD					GetSoftwareVersion(void);
	int						SizeMax();

	// IDrawCaption
	STDMETHODIMP			get_CaptionOn(flBool *flag);
	STDMETHODIMP			put_CaptionOn(flBool flag);
	STDMETHODIMP			get_Caption(flChar* caption);
	STDMETHODIMP			put_Caption(const flChar* caption);
	STDMETHODIMP			get_FontSize(flUInt *fontSize);
	STDMETHODIMP			put_FontSize(flUInt fontSize);

	// ISpecifyPropertyPages
	STDMETHODIMP			GetPages(CAUUID *pPages);

private:
	// CTransformInPlaceFilter Overrides
	HRESULT					Transform(IMediaSample *pSample);

protected:
    CCritSec			_filterLock;

	flBool				_captionOn;
	flChar				_caption[DC_MAXIMUM_CAPTION_LENGTH];
	flUInt				_fontSize;

	flTextDraw*			_textDraw;
};
//------------------------------------------------------------------------------
#endif //__DrawCaption_h__
