/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include <windows.h>
#define WIN32_LEAN_AND_MEAN
#include <streams.h>

#include <flDrawTools/DrawCaptionProp.h>
#include <commctrl.h>
#include <tchar.h>
#include "resource.h"
//------------------------------------------------------------------------------
CUnknown * WINAPI
CDrawCaptionProp::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
    CUnknown *punk = new CDrawCaptionProp(lpunk, phr);
    if (punk == NULL)
	{
		*phr = E_OUTOFMEMORY;
    }
    return punk;
}
//------------------------------------------------------------------------------
CDrawCaptionProp::CDrawCaptionProp(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("DrawCaptionProp"),pUnk,
                      IDD_DRAWCAPTIONPROP,
                      IDS_DRAWCAPTIONPROPTITLE),
    _drawCaption(NULL)
{
    InitCommonControls();
}
//------------------------------------------------------------------------------
void
CDrawCaptionProp::SetDirty()
{
    m_bDirty = TRUE;
    if (m_pPageSite)
	{
        m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
    }
}
//------------------------------------------------------------------------------
BOOL
CDrawCaptionProp::OnReceiveMessage(HWND hwnd,
                                UINT uMsg,
                                WPARAM wParam,
                                LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			setupControls();
			return (LRESULT) 1;
        }
        case WM_COMMAND:
        {
			switch(LOWORD(wParam))
			{
			case IDC_CAPTIONON_CHECK:
				if (HIWORD(wParam) == BN_CLICKED)
				{
					flInt checked = Button_GetCheck(GetDlgItem(m_Dlg, IDC_CAPTIONON_CHECK));
					_captionOn = (checked ? true : false);
					SetDirty();
				}
				break;
			case IDC_CAPTION_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[DC_MAXIMUM_CAPTION_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_CAPTION_EDIT), sz, DC_MAXIMUM_CAPTION_LENGTH);
					strcpy(_caption, sz);
					SetDirty();
				}
				break;
			case IDC_FONTSIZE_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_FONTSIZE_EDIT), sz, STR_MAX_LENGTH);
					_fontSize = _tstoi(sz);
					SetDirty();
				}
				break;
			}
			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
			shutdownControls();
            return (LRESULT) 1;
        }

    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);
}
//------------------------------------------------------------------------------
HRESULT
CDrawCaptionProp::OnConnect(IUnknown *pUnknown)
{
    ASSERT(_drawCaption == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IDrawCaption, (void **) &_drawCaption);
    if (FAILED(hr))
	{
        return E_NOINTERFACE;
    }

    ASSERT(_drawCaption);

	_drawCaption->get_CaptionOn(&_captionOn);
	_drawCaption->get_Caption(_caption);
	_drawCaption->get_FontSize(&_fontSize);

    return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CDrawCaptionProp::OnDisconnect()
{
    if (_drawCaption == NULL)
	{
        return E_UNEXPECTED;
    }

    _drawCaption->Release();
    _drawCaption = NULL;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CDrawCaptionProp::OnDeactivate(void)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CDrawCaptionProp::OnApplyChanges()
{
	_drawCaption->put_CaptionOn(_captionOn);
	_drawCaption->put_Caption(_caption);
	_drawCaption->put_FontSize(_fontSize);

    m_bDirty = FALSE;
	return(NOERROR);
}
//------------------------------------------------------------------------------
void
CDrawCaptionProp::setupControls()
{
	TCHAR   sz[1024];

	// Setup Controls
	Button_SetCheck(GetDlgItem(m_Dlg, IDC_CAPTIONON_CHECK), (_captionOn ? TRUE : FALSE));

	_stprintf(sz, "%s", _caption);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_CAPTION_EDIT), sz);

	_stprintf(sz, "%d", _fontSize);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_FONTSIZE_EDIT), sz);
}
//------------------------------------------------------------------------------
void
CDrawCaptionProp::shutdownControls()
{
}
//------------------------------------------------------------------------------
