/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __DrawCaptionProp_h__
#define __DrawCaptionProp_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif
#include <flTypes/flUIDs.h>
#include <flTypes/IDrawCaption.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CDrawCaptionProp : public CBasePropertyPage
{

public:
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN lpunk, HRESULT *phr);

private:
    CDrawCaptionProp(LPUNKNOWN lpunk, HRESULT *phr);

private:
    void		SetDirty();

	BOOL		OnReceiveMessage(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
    HRESULT		OnConnect(IUnknown *pUnknown);
    HRESULT		OnDisconnect();
    HRESULT		OnDeactivate();
    HRESULT		OnApplyChanges();

private:
	void		setupControls();
	void		shutdownControls();

private:
    IDrawCaption*	_drawCaption;

private:
	// Property
	flBool			_captionOn;
	flChar			_caption[DC_MAXIMUM_CAPTION_LENGTH];
	flUInt			_fontSize;
};
//------------------------------------------------------------------------------
#endif //__DrawCaptionProp_h__
