/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __DrawFrame_h__
#define __DrawFrame_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif

#include <flFilterCommon/flPointerInfo.h>
#include <flTypes/flUIDs.h>
#include <flTypes/IDrawFrame.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CDrawFrameInputPin;
class CDrawFrameOutputPin;
class CPointerInputPin;
//------------------------------------------------------------------------------
class CDrawFrame :
			public CTransInPlaceFilter,
			public CPersistStream, 
			public IDrawFrame,
			public ISpecifyPropertyPages
{
	friend class CPointerInputPin;

public:
	static CUnknown * WINAPI	CreateInstance(LPUNKNOWN punk, HRESULT *phr);

private:
	CDrawFrame(TCHAR *tszName, LPUNKNOWN punk, HRESULT *phr);
	virtual ~CDrawFrame();

public:
	DECLARE_IUNKNOWN;

public:
	STDMETHODIMP		NonDelegatingQueryInterface(REFIID riid, void ** ppv);

	// CTransInPlaceFilter Overrides
	virtual int			GetPinCount();
	virtual CBasePin*	GetPin( int n );
	STDMETHODIMP		FindPin(LPCWSTR Id, IPin **ppPin);

	HRESULT				CheckInputType(const CMediaType* mtIn);

	// IPersistStream
    STDMETHODIMP		GetClassID(CLSID *pClsid);
	HRESULT				WriteToStream(IStream *pStream);
    HRESULT				ReadFromStream(IStream *pStream);
	DWORD				GetSoftwareVersion(void);
	int					SizeMax();

	// IDrawFrame
	STDMETHODIMP		get_FrameOn(flBool *frameOn);
	STDMETHODIMP		put_FrameOn(flBool frameOn);
	STDMETHODIMP		get_FrameType(flInt *frameType);
	STDMETHODIMP		put_FrameType(flInt frameType);
	STDMETHODIMP		get_PointerInDisable(flBool* flag);
	STDMETHODIMP		put_PointerInDisable(flBool flag);
	STDMETHODIMP		get_Position(flInt* x, flInt* y);
	STDMETHODIMP		put_Position(flInt x, flInt y);
	STDMETHODIMP		get_Size(flUInt* width, flUInt* height);
	STDMETHODIMP		put_Size(flUInt width, flUInt height);
	STDMETHODIMP		get_Color(flByte* r, flByte* g, flByte* b);
	STDMETHODIMP		put_Color(flByte r, flByte g, flByte b);
	STDMETHODIMP		get_Thickness(flUInt* thickness);
	STDMETHODIMP		put_Thickness(flUInt thickness);

	// ISpecifyPropertyPages
	STDMETHODIMP		GetPages(CAUUID *pPages);

private:
	// CTransformInPlaceFilter Overrides
	HRESULT				Transform(IMediaSample *pSample);

private:
	HRESULT				ReceivePointer(IMediaSample *pSource, CPointerInputPin *ppin);

protected:
    CCritSec			_filterLock;

	flBool				_frameOn;
	flInt				_frameType;
	flBool				_pointerInDisable;
	flInt				_position[2];
	flUInt				_size[2];
	flByte				_color[3];
	flUInt				_thickness;

	flPointerInfo		_pointerInfo;

	CPointerInputPin*	_pointerInputPin;
};
//------------------------------------------------------------------------------
class CPointerInputPin : public CBaseInputPin
{
public:
	CPointerInputPin(TCHAR *pObjectName,
						CDrawFrame *pDrawFrame,
						HRESULT * phr,
						LPCWSTR pName);

public:
	HRESULT			CheckMediaType(const CMediaType* mtIn);

	// IMemInputPin
	STDMETHODIMP	Receive(IMediaSample * pSample);
	STDMETHODIMP	BeginFlush(void);
	STDMETHODIMP	EndFlush(void);
	STDMETHODIMP	EndOfStream(void);

	STDMETHODIMP	NewSegment(REFERENCE_TIME tStart, REFERENCE_TIME tStop, double dRate);

	virtual HRESULT	CheckStreaming();

protected:
	CDrawFrame		*_drawFrame;
};
//------------------------------------------------------------------------------
#endif //__DrawFrame_h__
