/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include <windows.h>
#define WIN32_LEAN_AND_MEAN
#include <streams.h>

#include <flDrawTools/DrawFrameProp.h>
#include <commctrl.h>
#include <tchar.h>
#include "resource.h"
//------------------------------------------------------------------------------
CUnknown * WINAPI
CDrawFrameProp::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
    CUnknown *punk = new CDrawFrameProp(lpunk, phr);
    if (punk == NULL)
	{
		*phr = E_OUTOFMEMORY;
    }
    return punk;
}
//------------------------------------------------------------------------------
CDrawFrameProp::CDrawFrameProp(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("DrawFrameProp"),pUnk,
                      IDD_DRAWFRAMEPROP,
                      IDS_DRAWFRAMEPROPTITLE),
    _drawFrame(NULL)
{
    InitCommonControls();
}
//------------------------------------------------------------------------------
void
CDrawFrameProp::SetDirty()
{
    m_bDirty = TRUE;
    if (m_pPageSite)
	{
        m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
    }
}
//------------------------------------------------------------------------------
BOOL
CDrawFrameProp::OnReceiveMessage(HWND hwnd,
                                UINT uMsg,
                                WPARAM wParam,
                                LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			setupControls();
			return (LRESULT) 1;
        }
        case WM_COMMAND:
        {
			switch(LOWORD(wParam))
			{
			case IDC_FRAMEON_CHECK:
				if (HIWORD(wParam) == BN_CLICKED)
				{
					flInt checked = Button_GetCheck(GetDlgItem(m_Dlg, IDC_FRAMEON_CHECK));
					_frameOn = (checked ? true : false);
					SetDirty();
				}
				break;
			case IDC_FRAMETYPE_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					_frameType = ComboBox_GetCurSel(GetDlgItem(m_Dlg, 
												IDC_FRAMETYPE_COMBO));
					SetDirty();
				}
				break;
			case IDC_POSITIONX_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_POSITIONX_EDIT), sz, STR_MAX_LENGTH);
					_position[0] = atoi(sz);
					SetDirty();
				}
				break;
			case IDC_POSITIONY_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_POSITIONY_EDIT), sz, STR_MAX_LENGTH);
					_position[1] = atoi(sz);
					SetDirty();
				}
				break;
			case IDC_POINTERINDISABLE_CHECK:
				if (HIWORD(wParam) == BN_CLICKED)
				{
					flInt checked = Button_GetCheck(GetDlgItem(m_Dlg, IDC_POINTERINDISABLE_CHECK));
					_pointerInDisable = (checked ? true : false);
					SetDirty();
				}
				break;
			case IDC_SIZEW_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_SIZEW_EDIT), sz, STR_MAX_LENGTH);
					_size[0] = atoi(sz);
					SetDirty();
				}
				break;
			case IDC_SIZEH_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_SIZEH_EDIT), sz, STR_MAX_LENGTH);
					_size[1] = atoi(sz);
					SetDirty();
				}
				break;
			case IDC_COLORR_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_COLORR_EDIT), sz, STR_MAX_LENGTH);
					_color[0] = atoi(sz);
					SetDirty();
				}
				break;
			case IDC_COLORG_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_COLORG_EDIT), sz, STR_MAX_LENGTH);
					_color[1] = atoi(sz);
					SetDirty();
				}
				break;
			case IDC_COLORB_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_COLORB_EDIT), sz, STR_MAX_LENGTH);
					_color[2] = atoi(sz);
					SetDirty();
				}
				break;
			case IDC_THICKNESS_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_THICKNESS_EDIT), sz, STR_MAX_LENGTH);
					_thickness = atoi(sz);
					SetDirty();
				}
				break;
			}
			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
			shutdownControls();
            return (LRESULT) 1;
        }

    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);
}
//------------------------------------------------------------------------------
HRESULT
CDrawFrameProp::OnConnect(IUnknown *pUnknown)
{
    ASSERT(_drawFrame == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IDrawFrame, (void **) &_drawFrame);
    if (FAILED(hr))
	{
        return E_NOINTERFACE;
    }

    ASSERT(_drawFrame);

	_drawFrame->get_FrameOn(&_frameOn);
	_drawFrame->get_FrameType(&_frameType);
	_drawFrame->get_Position(&_position[0], &_position[1]);
	_drawFrame->get_PointerInDisable(&_pointerInDisable);
	_drawFrame->get_Size(&_size[0], &_size[1]);
	_drawFrame->get_Color(&_color[0], &_color[1], &_color[2]);
	_drawFrame->get_Thickness(&_thickness);

    return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CDrawFrameProp::OnDisconnect()
{
    if (_drawFrame == NULL)
	{
        return E_UNEXPECTED;
    }

    _drawFrame->Release();
    _drawFrame = NULL;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CDrawFrameProp::OnDeactivate(void)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CDrawFrameProp::OnApplyChanges()
{
	_drawFrame->put_FrameOn(_frameOn);
	_drawFrame->put_FrameType(_frameType);
	_drawFrame->put_Position(_position[0], _position[1]);
	_drawFrame->put_PointerInDisable(_pointerInDisable);
	_drawFrame->put_Size(_size[0], _size[1]);
	_drawFrame->put_Color(_color[0], _color[1], _color[2]);
	_drawFrame->put_Thickness(_thickness);

    m_bDirty = FALSE;
	return(NOERROR);
}
//------------------------------------------------------------------------------
void
CDrawFrameProp::setupControls()
{
	TCHAR   sz[32];

	// Setup Controls
	Button_SetCheck(GetDlgItem(m_Dlg, IDC_FRAMEON_CHECK), (_frameOn ? TRUE : FALSE));

	HWND dlgItem = GetDlgItem(m_Dlg, IDC_FRAMETYPE_COMBO);
	ComboBox_ResetContent(dlgItem);
	ComboBox_AddString(dlgItem, "`");
	ComboBox_AddString(dlgItem, "ȉ~");
	ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_FRAMETYPE_COMBO), _frameType);

	_stprintf(sz, "%d", _position[0]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_POSITIONX_EDIT), sz);

	_stprintf(sz, "%d", _position[1]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_POSITIONY_EDIT), sz);

	Button_SetCheck(GetDlgItem(m_Dlg, IDC_POINTERINDISABLE_CHECK), (_pointerInDisable ? TRUE : FALSE));

	_stprintf(sz, "%d", _size[0]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_SIZEW_EDIT), sz);

	_stprintf(sz, "%d", _size[1]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_SIZEH_EDIT), sz);

	_stprintf(sz, "%d", _color[0]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_COLORR_EDIT), sz);

	_stprintf(sz, "%d", _color[1]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_COLORG_EDIT), sz);

	_stprintf(sz, "%d", _color[2]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_COLORB_EDIT), sz);

	_stprintf(sz, "%d", _thickness);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_THICKNESS_EDIT), sz);
}
//------------------------------------------------------------------------------
void
CDrawFrameProp::shutdownControls()
{
}
//------------------------------------------------------------------------------
