/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __DrawFrameProp_h__
#define __DrawFrameProp_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif
#include <flTypes/flUIDs.h>
#include <flTypes/IDrawFrame.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CDrawFrameProp : public CBasePropertyPage
{

public:
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN lpunk, HRESULT *phr);

private:
    CDrawFrameProp(LPUNKNOWN lpunk, HRESULT *phr);

private:
    void		SetDirty();

	BOOL		OnReceiveMessage(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
    HRESULT		OnConnect(IUnknown *pUnknown);
    HRESULT		OnDisconnect();
    HRESULT		OnDeactivate();
    HRESULT		OnApplyChanges();

private:
	void		setupControls();
	void		shutdownControls();

private:
    IDrawFrame	*_drawFrame;

private:
	// Property
	flBool		_frameOn;
	flInt		_frameType;
	flBool		_pointerInDisable;
	flInt		_position[2];
	flUInt		_size[2];
	flByte		_color[3];
	flUInt		_thickness;
};
//------------------------------------------------------------------------------
#endif //__DrawFrameProp_h__
