/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#define WIN32_LEAN_AND_MEAN
#include <streams.h>
#include <flDrawTools/DrawFrame.h>
#include <flDrawTools/DrawFrameProp.h>
#include <flDrawTools/DrawCaption.h>
#include <flDrawTools/DrawCaptionProp.h>
//------------------------------------------------------------------------------
const AMOVIESETUP_MEDIATYPE sudPinTypes =
{
	&MEDIATYPE_Video,
	&MEDIASUBTYPE_NULL
};
//------------------------------------------------------------------------------
const AMOVIESETUP_MEDIATYPE sudPPinTypes =
{
    &MEDIATYPE_Stream,
    &MEDIASUBTYPE_PointerInfo
};
//------------------------------------------------------------------------------
const AMOVIESETUP_PIN psudDrawFramePins[] =
{
	{
		L"Input",				// String pin name
		FALSE,					// Is it rendered
		FALSE,					// Is it an output
		FALSE,					// Allowed none
		FALSE,					// Allowed many
		&CLSID_NULL,			// Connects to filter
		L"Output",				// Connects to pin
		1,						// Number of types
		&sudPinTypes			// The pin details
	},
	{
		L"Output",				// String pin name
		FALSE,					// Is it rendered
		TRUE,					// Is it an output
		FALSE,					// Allowed none
		FALSE,					// Allowed many
		&CLSID_NULL,			// Connects to filter
		L"Input",				// Connects to pin
		1,						// Number of types
		&sudPinTypes			// The pin details
	},
	{
		L"Input Pointer",		// Pins string name
		FALSE,					// Is it rendered
		FALSE,					// Is it an output
		FALSE,					// Are we allowed none
		FALSE,					// And allowed many
		&CLSID_NULL,			// Connects to filter
		NULL,					// Connects to pin
		1,						// Number of types
		&sudPPinTypes			// Pin information
	}
};
//------------------------------------------------------------------------------
const AMOVIESETUP_PIN psudDrawCaptionPins[] =
{
	{
		L"Input",				// String pin name
		FALSE,					// Is it rendered
		FALSE,					// Is it an output
		FALSE,					// Allowed none
		FALSE,					// Allowed many
		&CLSID_NULL,			// Connects to filter
		L"Output",				// Connects to pin
		1,						// Number of types
		&sudPinTypes			// The pin details
	},
	{
		L"Output",				// String pin name
		FALSE,					// Is it rendered
		TRUE,					// Is it an output
		FALSE,					// Allowed none
		FALSE,					// Allowed many
		&CLSID_NULL,			// Connects to filter
		L"Input",				// Connects to pin
		1,						// Number of types
		&sudPinTypes			// The pin details
	}
};
//------------------------------------------------------------------------------
const AMOVIESETUP_FILTER sudDrawFrame =
{
	&CLSID_DrawFrame,			// Filter CLSID
	L"NIME Frame Draw Filter",	// Filter name
	MERIT_DO_NOT_USE,			// Its merit
	3,							// Number of pins
	psudDrawFramePins			// Pin details
};
//------------------------------------------------------------------------------
const AMOVIESETUP_FILTER sudDrawCaption =
{
	&CLSID_DrawCaption,			// Filter CLSID
	L"NIME Caption Draw Filter",// Filter name
	MERIT_DO_NOT_USE,			// Its merit
	2,							// Number of pins
	psudDrawCaptionPins			// Pin details
};
//------------------------------------------------------------------------------
CFactoryTemplate g_Templates[4] = {
    { L"DrawFrame"
    , &CLSID_DrawFrame
	, CDrawFrame::CreateInstance
    , NULL
    , &sudDrawFrame }
  ,
    { L"DrawFrameProp"
    , &CLSID_DrawFramePropertyPage
    , CDrawFrameProp::CreateInstance }
  ,
    { L"DrawCaption"
    , &CLSID_DrawCaption
	, CDrawCaption::CreateInstance
    , NULL
    , &sudDrawCaption }
  ,
    { L"DrawCaptionProp"
    , &CLSID_DrawCaptionPropertyPage
    , CDrawCaptionProp::CreateInstance }
};
int g_cTemplates = sizeof(g_Templates) / sizeof(g_Templates[0]);
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
//
// DllMain
//
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI DllEntryPoint(HINSTANCE, ULONG, LPVOID);
BOOL APIENTRY DllMain(HANDLE hModule, DWORD dwReason, LPVOID lpReserved)
{
    return DllEntryPoint((HINSTANCE)(hModule), dwReason, lpReserved);
}
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
//
// DllRegisterServer
//
//------------------------------------------------------------------------------
STDAPI DllRegisterServer()
{
    return AMovieDllRegisterServer2(TRUE);
}
//------------------------------------------------------------------------------
//
// DllUnregisterServer
//
//------------------------------------------------------------------------------
STDAPI DllUnregisterServer()
{
    return AMovieDllRegisterServer2(FALSE);
}
//------------------------------------------------------------------------------
