/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "Stdafx.h"

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <streams.h>

#include <flFilterCommon/flBufferInputPin.h>
#include <flFilterCommon/flBufferStream.h>
#include <flFilterCommon/flBuffer.h>
//------------------------------------------------------------------------------
CFLBuffer::CFLBuffer(TCHAR *pName, LPUNKNOWN lpunk, REFCLSID clsid) :
CBaseFilter(pName, lpunk, &_csFilter, clsid)
{
	_eosDelivered		= false;
	_sampleSkipped		= false;
	_qualityChanged		= false;

	_bufferInputPin		= NULL;
	_bufferStream		= NULL;
}
//------------------------------------------------------------------------------
CFLBuffer::~CFLBuffer()
{
	delete _bufferStream;
	delete _bufferInputPin;
}
//------------------------------------------------------------------------------
// obt@O
HRESULT
CFLBuffer::Buffering(IMediaSample *)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CFLBuffer::Deliver(IMediaSample *)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
void
CFLBuffer::AdjustDeliverRate(flInt64 deliverProcTime)
{
}
//------------------------------------------------------------------------------
// s̑
flInt
CFLBuffer::GetPinCount()
{
	return 2;
}
//------------------------------------------------------------------------------
CBasePin*
CFLBuffer::GetPin(flInt n)
{
	HRESULT hr = S_OK;

	if (_bufferInputPin == NULL)
	{
		_bufferInputPin = new CFLBufferInputPin("Buffer Input Pin", this, &hr, L"In");

		ASSERT(SUCCEEDED(hr));
		if (_bufferInputPin == NULL)
		{
			return NULL;
		}
	}

	if (_bufferStream == NULL)
	{
		_bufferStream = new CFLBufferStream("Buffer Streamm", &hr, this, L"Out");

		ASSERT(SUCCEEDED(hr));
		if (_bufferStream == NULL)
		{
			delete _bufferInputPin;
			return NULL;
		}
	}

	if (n == 0)
		return _bufferInputPin;
	else if (n == 1)
		return _bufferStream;
	else
		return NULL;
}
//------------------------------------------------------------------------------
STDMETHODIMP
CFLBuffer::FindPin(LPCWSTR Id, IPin **ppPin)
{
    CheckPointer(ppPin, E_POINTER);
    ValidateReadWritePtr(ppPin, sizeof(IPin *));

	if (!lstrcmpW(Id, L"In"))
	{
		*ppPin = GetPin(0);
	}
	else if (!lstrcmpW(Id, L"Out"))
	{
		*ppPin = GetPin(1);
	}

	if (ppPin != NULL)
	{
		(*ppPin)->AddRef();
		return NOERROR;
	}
	else
	{
		return VFW_E_NOT_FOUND;
	}
}
//------------------------------------------------------------------------------
// Xg[~O
STDMETHODIMP
CFLBuffer::Stop()
{
	CAutoLock lck1(&_csFilter);
	if (m_State == State_Stopped)
		return NOERROR;

	ASSERT(_bufferInputPin == NULL || _bufferStream != NULL);

	if (_bufferInputPin == NULL ||
		_bufferInputPin->IsConnected() == FALSE ||
		_bufferStream->IsConnected() == FALSE)
	{
		m_State = State_Stopped;
		_eosDelivered = FALSE;
		return NOERROR;
	}

	ASSERT(_bufferInputPin != NULL);
	ASSERT(_bufferStream != NULL);

	_bufferInputPin->Inactive();

	CAutoLock lck2(&_csReceive);
	_bufferStream->Inactive();

	HRESULT hr = StopStreaming();
	if (SUCCEEDED(hr))
	{
		m_State = State_Stopped;
		_eosDelivered = FALSE;
	}
	return hr;
}
//------------------------------------------------------------------------------
STDMETHODIMP
CFLBuffer::Pause()
{
	CAutoLock lck(&_csFilter);
	HRESULT hr = NOERROR;

	if (m_State == State_Paused)
	{
		// (This space left deliberately blank)
	}
	else if (_bufferInputPin == NULL || _bufferInputPin->IsConnected() == FALSE)
	{
		if (_bufferStream != NULL && _eosDelivered == FALSE)
		{
			_bufferStream->DeliverEndOfStream();
			_eosDelivered = TRUE;
		}
		m_State = State_Paused;
	}
	else if (_bufferStream->IsConnected() == FALSE)
	{
		m_State = State_Paused;
	}
	else
	{
		if (m_State == State_Stopped)
		{
			CAutoLock lck2(&_csReceive);
			hr = StartStreaming();
		}
		if (SUCCEEDED(hr))
		{
			hr = CBaseFilter::Pause();
		}
	}

	_sampleSkipped = FALSE;
	_qualityChanged = FALSE;

	return hr;
}
//------------------------------------------------------------------------------
HRESULT
CFLBuffer::StartStreaming()
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CFLBuffer::StopStreaming()
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CFLBuffer::OnStartDelivery()
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CFLBuffer::OnEndDelivery()
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CFLBuffer::Receive(IMediaSample *pSample)
{
	ASSERT(_bufferInputPin != NULL);

	AM_SAMPLE2_PROPERTIES * const pProps = _bufferInputPin->SampleProps();
	if (pProps->dwStreamId != AM_STREAM_MEDIA)
		return NOERROR;

	ASSERT(pSample != NULL);
	ASSERT(_bufferStream != NULL);

	return Buffering(pSample);
}
//------------------------------------------------------------------------------
HRESULT
CFLBuffer::SetMediaType(PIN_DIRECTION, const CMediaType *)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CFLBuffer::CheckConnect(PIN_DIRECTION, IPin *)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CFLBuffer::BreakConnect(PIN_DIRECTION)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CFLBuffer::CompleteConnect(PIN_DIRECTION, IPin *)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CFLBuffer::EndOfStream()
{
	HRESULT hr = NOERROR;
	if (_bufferStream != NULL)
	{
		hr = _bufferStream->DeliverEndOfStream();
	}
	return hr;
}
//------------------------------------------------------------------------------
HRESULT
CFLBuffer::BeginFlush()
{
	HRESULT hr = NOERROR;
	if (_bufferStream != NULL)
	{
		hr = _bufferStream->DeliverBeginFlush();
	}
	return hr;
}
//------------------------------------------------------------------------------
HRESULT
CFLBuffer::EndFlush()
{
	ASSERT(_bufferStream != NULL);
	return _bufferStream->DeliverEndFlush();
}
//------------------------------------------------------------------------------
HRESULT
CFLBuffer::NewSegment(REFERENCE_TIME tStart,
					  REFERENCE_TIME tStop,
					  double dRate)
{
	if (_bufferStream != NULL)
		return _bufferStream->DeliverNewSegment(tStart, tStop, dRate);

	return S_OK;
}
//------------------------------------------------------------------------------
HRESULT
CFLBuffer::AlterQuality(Quality)
{
	return S_FALSE;
}
//------------------------------------------------------------------------------
HRESULT
CFLBuffer::InitializeOutputSample(IMediaSample **ppOutSample)
{
	ASSERT(_bufferStream->m_pAllocator != NULL);
	return _bufferStream->m_pAllocator->GetBuffer(ppOutSample, NULL, NULL, 0);
/*
	ASSERT(_bufferInputPin != NULL);
	if (_bufferInputPin->IsConnected() == FALSE)
		return E_FAIL;

	IMediaSample *pOutSample;

	AM_SAMPLE2_PROPERTIES * const pProps = _bufferInputPin->SampleProps();
	DWORD dwFlags = _sampleSkipped ? AM_GBF_PREVFRAMESKIPPED : 0;

	if (!(pProps->dwSampleFlags & AM_SAMPLE_SPLICEPOINT))
		dwFlags |= AM_GBF_NOTASYNCPOINT;

	ASSERT(_bufferStream->m_pAllocator != NULL);
	HRESULT hr = _bufferStream->m_pAllocator->GetBuffer(
				&pOutSample,
				pProps->dwSampleFlags & AM_SAMPLE_TIMEVALID ? &pProps->tStart : NULL,
				pProps->dwSampleFlags & AM_SAMPLE_STOPVALID ? &pProps->tStop : NULL,
				dwFlags);

	*ppOutSample = pOutSample;
	if (FAILED(hr))
		return hr;

	ASSERT(pOutSample != NULL);
	IMediaSample2 *pOutSample2;

	if (SUCCEEDED(pOutSample->QueryInterface(IID_IMediaSample2, (void **)&pOutSample2)))
	{
		AM_SAMPLE2_PROPERTIES OutProps;
		EXECUTE_ASSERT(SUCCEEDED(pOutSample2->GetProperties(
			FIELD_OFFSET(AM_SAMPLE2_PROPERTIES, tStart), (PBYTE)&OutProps)
		));
		OutProps.dwTypeSpecificFlags = pProps->dwTypeSpecificFlags;
		OutProps.dwSampleFlags =
			(OutProps.dwSampleFlags & AM_SAMPLE_TYPECHANGED) |
			(pProps->dwSampleFlags & ~AM_SAMPLE_TYPECHANGED);
		OutProps.tStart = pProps->tStart;
		OutProps.tStop  = pProps->tStop;
		OutProps.cbData = FIELD_OFFSET(AM_SAMPLE2_PROPERTIES, dwStreamId);
		hr = pOutSample2->SetProperties(
			FIELD_OFFSET(AM_SAMPLE2_PROPERTIES, dwStreamId),
			(PBYTE)&OutProps
		);
		if (pProps->dwSampleFlags & AM_SAMPLE_DATADISCONTINUITY)
			_sampleSkipped = FALSE;

		pOutSample2->Release();
	}
	else
	{
		if (pProps->dwSampleFlags & AM_SAMPLE_TIMEVALID)
		{
			pOutSample->SetTime(&pProps->tStart, &pProps->tStop);
		}
		if (pProps->dwSampleFlags & AM_SAMPLE_SPLICEPOINT)
		{
			pOutSample->SetSyncPoint(TRUE);
		}
		if (pProps->dwSampleFlags & AM_SAMPLE_DATADISCONTINUITY)
		{
			pOutSample->SetDiscontinuity(TRUE);
			_sampleSkipped = FALSE;
		}
	}

	return S_OK;
*/
}
//------------------------------------------------------------------------------
