/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flBuffer_h__
#define __flBuffer_h__
//------------------------------------------------------------------------------
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CFLBufferInputPin;
class CFLBufferStream;
//------------------------------------------------------------------------------
class AM_NOVTABLE CFLBuffer : public CBaseFilter
{
	friend class CFLBufferInputPin;
	friend class CFLBufferStream;

public:
	CFLBuffer(TCHAR *pName, LPUNKNOWN lpunk, REFCLSID clsid);
	~CFLBuffer();

public:
	// obt@O
	virtual HRESULT		Buffering(IMediaSample *pSample);
	virtual HRESULT		Deliver(IMediaSample *pSample);

	virtual void		AdjustDeliverRate(flInt64 deliverProcTime);

public:
	// s̑
	virtual flInt		GetPinCount();
	virtual CBasePin*	GetPin(flInt n);
	STDMETHODIMP		FindPin(LPCWSTR Id, IPin **ppPin);

public:
	// Xg[~O
	STDMETHODIMP		Stop();
	STDMETHODIMP		Pause();

	virtual HRESULT		StartStreaming();
	virtual HRESULT		StopStreaming();

	virtual HRESULT		OnStartDelivery();
	virtual HRESULT		OnEndDelivery();

public:
	virtual HRESULT		Receive(IMediaSample *pSample);

	virtual HRESULT		SetMediaType(PIN_DIRECTION direction, const CMediaType *pmt);
	virtual HRESULT		CheckConnect(PIN_DIRECTION direction, IPin *pPin);
	virtual HRESULT		BreakConnect(PIN_DIRECTION direction);
	virtual HRESULT		CompleteConnect(PIN_DIRECTION direction, IPin *pReceivePin);

	virtual HRESULT		EndOfStream();
	virtual HRESULT		BeginFlush();
	virtual HRESULT		EndFlush();
	virtual HRESULT		NewSegment(REFERENCE_TIME tStart,
									REFERENCE_TIME tStop,
									double dRate);

	virtual HRESULT		AlterQuality(Quality q);

	HRESULT				InitializeOutputSample(IMediaSample **ppOutSample);

public:
	virtual HRESULT		CheckInputType(const CMediaType* mtIn) PURE;
	virtual HRESULT		CheckTransform(const CMediaType* mtIn, const CMediaType* mtOut) PURE;
	virtual HRESULT		DecideBufferSize(IMemAllocator * pAllocator,
										ALLOCATOR_PROPERTIES *pprop) PURE;
	virtual HRESULT		GetMediaType(flInt iPosition, CMediaType *pMediaType) PURE;

protected:
	flBool					_eosDelivered;
	flBool					_sampleSkipped;
	flBool					_qualityChanged;

	CCritSec				_csFilter;
	CCritSec				_csReceive;

	CFLBufferInputPin*		_bufferInputPin;
	CFLBufferStream*		_bufferStream;
};
//------------------------------------------------------------------------------
#endif //__flBuffer_h__
