/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "Stdafx.h"

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <streams.h>

#include <flFilterCommon/flBufferInputPin.h>
#include <flFilterCommon/flBufferStream.h>
#include <flFilterCommon/flBuffer.h>
#include <flBase/flSystemTime.h>
//------------------------------------------------------------------------------
CFLBufferInputPin::CFLBufferInputPin(TCHAR *pObjectName,
									 CFLBuffer *filter,
									 HRESULT *phr,
									 LPCWSTR pName) :
CBaseInputPin(pObjectName, filter, &filter->_csFilter, phr, pName)
{
	_bufferFilter	= filter;
	_absTime		= new flSystemTime();
}
//------------------------------------------------------------------------------
CFLBufferInputPin::~CFLBufferInputPin()
{
	delete _absTime;
}
//------------------------------------------------------------------------------
STDMETHODIMP
CFLBufferInputPin::QueryId(LPWSTR *Id)
{
	return AMGetWideString(L"In", Id);
}
//------------------------------------------------------------------------------
HRESULT
CFLBufferInputPin::CheckConnect(IPin *pPin)
{
	HRESULT hr = _bufferFilter->CheckConnect(PINDIR_INPUT, pPin);
	if (FAILED(hr))
		return hr;

	return CBaseInputPin::CheckConnect(pPin);
}
//------------------------------------------------------------------------------
HRESULT
CFLBufferInputPin::BreakConnect()
{
	ASSERT(IsStopped());
	_bufferFilter->BreakConnect(PINDIR_INPUT);
	return CBaseInputPin::BreakConnect();
}
//------------------------------------------------------------------------------
HRESULT
CFLBufferInputPin::CompleteConnect(IPin *pReceivePin)
{
	HRESULT hr = _bufferFilter->CompleteConnect(PINDIR_INPUT, pReceivePin);
	if (FAILED(hr))
		return hr;

	return CBaseInputPin::CompleteConnect(pReceivePin);
}
//------------------------------------------------------------------------------
HRESULT
CFLBufferInputPin::CheckMediaType(const CMediaType* pmt)
{
	HRESULT hr = _bufferFilter->CheckInputType(pmt);
	if (hr != S_OK)
		return hr;

	if ((_bufferFilter->_bufferStream != NULL) && (_bufferFilter->_bufferStream->IsConnected()))
		return _bufferFilter->CheckTransform(pmt,	&_bufferFilter->_bufferStream->CurrentMediaType());
	else
		return hr;
}
//------------------------------------------------------------------------------
HRESULT
CFLBufferInputPin::SetMediaType(const CMediaType* mtIn)
{
	HRESULT hr = CBasePin::SetMediaType(mtIn);
	if (FAILED(hr))
		return hr;

	ASSERT(SUCCEEDED(_bufferFilter->CheckInputType(mtIn)));

	return _bufferFilter->SetMediaType(PINDIR_INPUT, mtIn);
}
//------------------------------------------------------------------------------
STDMETHODIMP
CFLBufferInputPin::Receive(IMediaSample * pSample)
{
	ASSERT(pSample != NULL);

	HRESULT hr;
	CAutoLock lock(&_bufferFilter->_csReceive);

	hr = CBaseInputPin::Receive(pSample);
	if (hr != S_OK)
		return hr;

#if 0
	REFERENCE_TIME timeStart, timeEnd;
	hr = pSample->GetTime(&timeStart, &timeEnd);

	if (hr == S_OK)
	{
		// Xg[^Cݒ肳ĂꍇM^C~O̒sB
		_absTime->update();
		flInt64 procStartTime = _absTime->getTime();

		hr = _bufferFilter->Receive(pSample);

		_absTime->update();
		flInt64 procTime = _absTime->getTime() - procStartTime;
		flInt64 sleepTime = timeEnd - timeStart - procTime;
		if (0 < sleepTime)
			Sleep(flULong(sleepTime / 10000));
	}
	else
	{
		// M^C~O̒sȂB
		hr = _bufferFilter->Receive(pSample);
		Sleep(0);
	}
#else
	hr = _bufferFilter->Receive(pSample);
	Sleep(0);
#endif

	return hr;
}
//------------------------------------------------------------------------------
STDMETHODIMP
CFLBufferInputPin::EndOfStream()
{
	CAutoLock lock(&_bufferFilter->_csReceive);
	HRESULT hr = CheckStreaming();
	if (hr == S_OK)
		hr = _bufferFilter->EndOfStream();

	return hr;
}
//------------------------------------------------------------------------------
STDMETHODIMP
CFLBufferInputPin::BeginFlush()
{
	CAutoLock lock(m_pLock);

	HRESULT hr = CBaseInputPin::BeginFlush();
	if (FAILED(hr))
		return hr;

	hr = _bufferFilter->BeginFlush();
	if (FAILED(hr))
		return hr;

/*
	// Receive \bhCxg҂ĂꍇA
	// \bh̓~B
	SetEvent(m_hSomeEventThatReceiveNeedsToWaitOn);

	// ̎_ŁAReceive \bh̓͒~łȂB
	// Xg[~O bNAImFB
	// (ꂪŌ̃Xebvłꍇ͕KvȂB)
	{ 
		CAutoLock lock_2(&_bufferFilter->_csReceive);

		// ł́AReceive sȂNbVnO鏈
		//	sĂSłB
	}
*/
	return hr;
}
//------------------------------------------------------------------------------
STDMETHODIMP
CFLBufferInputPin::EndFlush()
{
	CAutoLock lock(m_pLock);

	HRESULT hr = _bufferFilter->EndFlush();
	if (FAILED(hr))
		return hr;

	return CBaseInputPin::EndFlush();
}
//------------------------------------------------------------------------------
STDMETHODIMP
CFLBufferInputPin::NewSegment(REFERENCE_TIME tStart,
							  REFERENCE_TIME tStop,
							  flDouble dRate)
{
	CBasePin::NewSegment(tStart, tStop, dRate);
	return _bufferFilter->NewSegment(tStart, tStop, dRate);
}
//------------------------------------------------------------------------------
HRESULT
CFLBufferInputPin::CheckStreaming()
{
	ASSERT(_bufferFilter->_bufferStream != NULL);

	if (!_bufferFilter->_bufferStream->IsConnected())
	{
		return VFW_E_NOT_CONNECTED;
	}
	else
	{
		ASSERT(IsConnected());

		if (m_bFlushing)
			return S_FALSE;

		if (IsStopped())
			return VFW_E_WRONG_STATE;

		if (m_bRunTimeError)
    		return VFW_E_RUNTIME_ERROR;

		return S_OK;
	}
}
//------------------------------------------------------------------------------
CMediaType&
CFLBufferInputPin::CurrentMediaType()
{
	return m_mt;
}
//------------------------------------------------------------------------------
