/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flBufferInputPin_h__
#define __flBufferInputPin_h__
//------------------------------------------------------------------------------
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class flAbsoluteTime;
class CFLBuffer;
//------------------------------------------------------------------------------
class CFLBufferInputPin : public CBaseInputPin
{
    friend class CFLBuffer;
public:
	CFLBufferInputPin(TCHAR *pObjectName,
						CFLBuffer *pFilter,
						HRESULT * phr,
						LPCWSTR pName);
	virtual ~CFLBufferInputPin();

public:
	STDMETHODIMP	QueryId(LPWSTR * Id);

	HRESULT			CheckConnect(IPin *pPin);
	HRESULT			BreakConnect();
	HRESULT			CompleteConnect(IPin *pReceivePin);

	HRESULT			CheckMediaType(const CMediaType* mtIn);
	HRESULT			SetMediaType(const CMediaType* mt);

	STDMETHODIMP	Receive(IMediaSample * pSample);
	STDMETHODIMP	EndOfStream();
	STDMETHODIMP	BeginFlush();
	STDMETHODIMP	EndFlush();
	STDMETHODIMP	NewSegment(REFERENCE_TIME tStart,
								REFERENCE_TIME tStop,
								flDouble dRate);

	virtual HRESULT	CheckStreaming();

public:
    CMediaType&		CurrentMediaType();

protected:
	CFLBuffer*		_bufferFilter;
	flAbsoluteTime*	_absTime;
};
//------------------------------------------------------------------------------
#endif //__flBufferInputPin_h__
