/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "Stdafx.h"
#include <flFilterCommon/flFillColor.h>
//------------------------------------------------------------------------------
flFillColor::flFillColor(flUInt videoWidth, flUInt videoHeight) :
flShapeDraw(videoWidth, videoHeight)
{
	_buffer			= NULL;
	_bufferLength	= 0;
}
//------------------------------------------------------------------------------
flFillColor::flFillColor() :
flShapeDraw()
{
	_buffer			= NULL;
	_bufferLength	= 0;
}
//------------------------------------------------------------------------------
flFillColor::~flFillColor()
{
	delete _buffer;
}
//------------------------------------------------------------------------------
void
flFillColor::draw(flByte* data)
{
	if (data == NULL)
		return ;

	if (_videoWidth * _videoHeight * 3 != _bufferLength)
	{
		_bufferLength = _videoWidth * _videoHeight * 3;

		delete _buffer;
		_buffer = new flByte[_bufferLength];

		flByte* ptr = _buffer;

		while(ptr < _buffer + _bufferLength)
		{
			CopyMemory(ptr, _color, 3);
			ptr += 3;
		}
	}

	CopyMemory(data, _buffer, _bufferLength);
}
//------------------------------------------------------------------------------
const flByte*
flFillColor::getColor() const
{
	return _color;
}
//------------------------------------------------------------------------------
void
flFillColor::setColor(const flByte* color)
{
	_color[0] = color[2];
	_color[1] = color[1];
	_color[2] = color[0];

	flByte* ptr = _buffer;
	while(ptr < _buffer + _bufferLength)
	{
		CopyMemory(ptr, _color, 3);
		ptr += 3;
	}
}
//------------------------------------------------------------------------------
