/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flLocusDraw_h__
#define __flLocusDraw_h__
//------------------------------------------------------------------------------
#include <flFilterCommon/flShapeDraw.h>
#include <flBase/flArray.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
struct flPoint
{
	flPoint()
	{
		x = 0;
		y = 0;
	}
	flPoint(flShort x, flShort y)
	{
		this->x = x;
		this->y = y;
	}

    flBool		operator==(const flPoint& point) const
	{
		return (this->x == point.x && this->y == point.y);
	}
    flBool		operator!=(const flPoint& point) const
	{
		return !(this->x == point.x && this->y == point.y);
	}

	flShort	x;
	flShort	y;
};
//------------------------------------------------------------------------------
class flLocusDraw : public flShapeDraw
{
public:
	flLocusDraw(flUInt videoWidth, flUInt videoHeight);
	flLocusDraw();
	virtual ~flLocusDraw();

public:
	virtual void	draw(flByte* data);

public:
	void			addPoint(flShort x, flShort y);
	void			addDiscontinuousPoint();
	void			clearPoints();

	const flByte*	getColor() const;
	void			setColor(const flByte* color);

	void			setEdgingOn(flBool flag);
	flBool			getEdgingOn() const;

	void			setBrokenLineOn(flBool flag);
	flBool			getBrokenLineOn() const;

	void			setLineWidth(flUInt width);
	flUInt			getLineWidth() const;

private:
	void			rectangle(flByte* data, flShort x1, flShort y1, flShort x2, flShort y2,
								const flByte* color, flBool fill);

protected:
	flArray<flPoint>	_points;
	flByte				_color[3];
	flBool				_edgingOn;
	flBool				_brokenLineOn;
	flUInt				_lineWidth;
};
//------------------------------------------------------------------------------
DECLARE_SAFE_COPYFUNC(flLocusDraw);
DECLARE_SAFE_COMPFUNC(flLocusDraw);
//------------------------------------------------------------------------------
#endif //__flLocusDraw_h__
